package com.xebialabs.deployit;

import com.xebialabs.deployit.errors.LicenseMissingErrorHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.Callback;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CustomErrorHandler extends ErrorHandler {

    private final HttpErrorHandler handlers[];

    /**
     * default constructor for backwards compatibility.
     */
    public CustomErrorHandler() {
        this(new LicenseMissingErrorHandler());
    }

    public CustomErrorHandler(HttpErrorHandler... handlers) {
        this.handlers = handlers;
    }

    @Override
    protected boolean generateAcceptableResponse(Request request, Response response, Callback callback, String contentType, List<Charset> charsets, int code, String message, Throwable cause) throws IOException {
        Arrays.stream(handlers)
                .filter(h -> h.canHandle(request, code))
                .findFirst()
                .ifPresent(h -> h.changeResponse(response));
        return super.generateAcceptableResponse(request, response, callback, contentType, charsets, code, message, cause);
    }

    @Override
    protected void writeErrorHtml(Request request, Writer writer, Charset charset, int code, String message, Throwable cause) throws IOException {
        Optional<HttpErrorHandler> handler = Arrays.stream(handlers)
                .filter(h -> h.canHandle(request, code))
                .findFirst();
        if (handler.isPresent()) {
            handler.get().writeErrorContent(writer);
        } else {
            super.writeErrorHtml(request, writer, charset, code, message, cause);
        }
    }

}
