/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployfile;

import com.google.common.io.Files;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.deployfile.ApplicationSpec;
import com.xebialabs.deployit.deployfile.DirectorySpec;
import com.xebialabs.deployit.deployfile.ForDirectories;
import com.xebialabs.deployit.deployfile.XldSpec;
import com.xebialabs.deployit.deployfile.execute.CiCommand;
import com.xebialabs.deployit.deployfile.execute.CiCommandCreator;
import com.xebialabs.deployit.deployfile.execute.CommandExecutor;
import com.xebialabs.deployit.deployfile.execute.DeleteCiCommand;
import com.xebialabs.deployit.deployfile.execute.DeployfileCommand;
import com.xebialabs.deployit.deployfile.execute.DeployfileExecutor;
import com.xebialabs.deployit.deployfile.execute.DeployfileResolver;
import com.xebialabs.deployit.deployfile.export.DeployfileGenerator;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.PathHelper;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@ScalaSignature(bytes="\u0006\u0001\t%f\u0001B\u0001\u0003\u0001-\u00111\u0003R3qY>Lh-\u001b7f!J|7-Z:t_JT!a\u0001\u0003\u0002\u0015\u0011,\u0007\u000f\\8zM&dWM\u0003\u0002\u0006\r\u0005AA-\u001a9m_fLGO\u0003\u0002\b\u0011\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bQi\u0011A\u0004\u0006\u0003\u001fA\tqa]3dkJ,GM\u0003\u0002\u0012%\u0005!!/Z:u\u0015\t\u0019B!\u0001\u0003d_J,\u0017BA\u000b\u000f\u0005]\t%m\u001d;sC\u000e$8+Z2ve\u0016$'+Z:pkJ\u001cW\r\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003E\u0011X\r]8tSR|'/_*feZL7-\u001a\t\u00033qi\u0011A\u0007\u0006\u00037\u0011\t!B]3q_NLGo\u001c:z\u0013\ti\"DA\tSKB|7/\u001b;pef\u001cVM\u001d<jG\u0016D#AF\u0010\u0011\u0005\u0001ZS\"A\u0011\u000b\u0005\t\u001a\u0013AC1o]>$\u0018\r^5p]*\u0011A%J\u0001\bM\u0006\u001cGo\u001c:z\u0015\t1s%A\u0003cK\u0006t7O\u0003\u0002)S\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001+\u0003\ry'oZ\u0005\u0003Y\u0005\u0012\u0011\"Q;u_^L'/\u001a3\t\u00119\u0002!\u0011!Q\u0001\n=\n1\u0003Z3qY>Lh-\u001b7f\u000f\u0016tWM]1u_J\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0002\u0002\r\u0015D\bo\u001c:u\u0013\t!\u0014GA\nEKBdw.\u001f4jY\u0016<UM\\3sCR|'\u000f\u000b\u0002.?!Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\neKBdw.\u001f4jY\u0016,\u00050Z2vi>\u0014\bCA\u001d=\u001b\u0005Q$BA\u001e\u0003\u0003\u001d)\u00070Z2vi\u0016L!!\u0010\u001e\u0003%\u0011+\u0007\u000f\\8zM&dW-\u0012=fGV$xN\u001d\u0015\u0003m}A\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!Q\u0001\u0013I\u0016\u0004Hn\\=gS2,'+Z:pYZ,'\u000f\u0005\u0002:\u0005&\u00111I\u000f\u0002\u0013\t\u0016\u0004Hn\\=gS2,'+Z:pYZ,'\u000f\u000b\u0002@?!Aa\t\u0001B\u0001B\u0003%q)\u0001\bd_6l\u0017M\u001c3De\u0016\fGo\u001c:\u0011\u0005eB\u0015BA%;\u0005A\u0019\u0015nQ8n[\u0006tGm\u0011:fCR|'\u000f\u000b\u0002F?!AA\n\u0001B\u0001B\u0003%Q*A\bd_6l\u0017M\u001c3Fq\u0016\u001cW\u000f^8s!\tId*\u0003\u0002Pu\ty1i\\7nC:$W\t_3dkR|'\u000f\u000b\u0002L?!A!\u000b\u0001B\u0001B\u0003%1+A\u0005wC2LG-\u0019;peB\u0011A+W\u0007\u0002+*\u0011akV\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'B\u0001-\u0005\u0003\u001d\u0019XM\u001d<jG\u0016L!AW+\u0003\u0013Y\u000bG.\u001b3bi>\u0014\bFA) \u0011\u0015i\u0006\u0001\"\u0001_\u0003\u0019a\u0014N\\5u}QAq,Y2fO&\\W\u000e\u0005\u0002a\u00015\t!\u0001C\u0003\u00189\u0002\u0007\u0001\u0004\u000b\u0002b?!)a\u0006\u0018a\u0001_!\u00121m\b\u0005\u0006oq\u0003\r\u0001\u000f\u0015\u0003K~AQ\u0001\u0011/A\u0002\u0005C#aZ\u0010\t\u000b\u0019c\u0006\u0019A$)\u0005%|\u0002\"\u0002']\u0001\u0004i\u0005FA6 \u0011\u0015\u0011F\f1\u0001TQ\tiw\u0004C\u0004q\u0001\t\u0007I\u0011B9\u0002\r1|wmZ3s+\u0005\u0011\bCA:w\u001b\u0005!(BA;*\u0003\u0015\u0019HN\u001a\u001bk\u0013\t9HO\u0001\u0004M_\u001e<WM\u001d\u0005\u0007s\u0002\u0001\u000b\u0011\u0002:\u0002\u000f1|wmZ3sA!)1\u0010\u0001C\u0001y\u00069Am\\!qa2LHcB?\u0002(\u0005-\u0012\u0011\u000b\t\u0006}\u0006E\u0011q\u0003\b\u0004\u007f\u0006-a\u0002BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015!\"\u0001\u0004=e>|GOP\u0005\u0003\u0003\u0013\tQa]2bY\u0006LA!!\u0004\u0002\u0010\u00059\u0001/Y2lC\u001e,'BAA\u0005\u0013\u0011\t\u0019\"!\u0006\u0003\t1K7\u000f\u001e\u0006\u0005\u0003\u001b\ty\u0001\u0005\u0003\u0002\u001a\u0005\u0005b\u0002BA\u000e\u0003;\u0001B!!\u0001\u0002\u0010%!\u0011qDA\b\u0003\u0019\u0001&/\u001a3fM&!\u00111EA\u0013\u0005\u0019\u0019FO]5oO*!\u0011qDA\b\u0011\u001d\tIC\u001fa\u0001\u0003/\t!\u0002Z3qY>Lh)\u001b7f\u0011\u001d\tiC\u001fa\u0001\u0003_\t\u0011\"\u0019:uS\u001a\f7\r^:\u0011\u000by\f\t$!\u000e\n\t\u0005M\u0012Q\u0003\u0002\u0004'\u0016\f\b\u0003BA\u001c\u0003\u001bj!!!\u000f\u000b\t\u0005m\u0012QH\u0001\n[VdG/\u001b9beRTA!a\u0010\u0002B\u0005I\u0001O]8wS\u0012,'o\u001d\u0006\u0005\u0003\u0007\n)%A\u0004qYV<\u0017N\\:\u000b\t\u0005\u001d\u0013\u0011J\u0001\te\u0016\u001cH/Z1ts*\u0019\u00111J\u0015\u0002\u000b)\u0014wn]:\n\t\u0005=\u0013\u0011\b\u0002\n\u0013:\u0004X\u000f\u001e)beRD\u0011\"a\u0015{!\u0003\u0005\r!!\u0016\u0002#I,7o\\;sG\u0016$\u0015N]3di>\u0014\u0018\u0010\u0005\u0003\u0002X\u0005\u0005TBAA-\u0015\u0011\tY&!\u0018\u0002\u0005%|'BAA0\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0014\u0011\f\u0002\u0005\r&dW\rC\u0004\u0002h\u0001!\t!!\u001b\u0002\u0015\u0011|w)\u001a8fe\u0006$X\r\u0006\u0003\u0002\u0018\u0005-\u0004\u0002CA7\u0003K\u0002\r!a\u001c\u0002\u000f\u0019|G\u000eZ3sgB1\u0011\u0011OA<\u0003/i!!a\u001d\u000b\t\u0005U\u0014QL\u0001\u0005kRLG.\u0003\u0003\u0002\u0014\u0005M\u0004bBA>\u0001\u0011%\u0011QP\u0001\u0010m\u0006d\u0017\u000eZ1uKbcGm\u00159fGR!\u0011qPAD!\u0011\t\t)a!\u000e\u0005\u0005=\u0011\u0002BAC\u0003\u001f\u0011A!\u00168ji\"A\u0011\u0011RA=\u0001\u0004\tY)\u0001\u0005yY\u0012\u001c\u0006/Z2t!\u0015q\u0018\u0011CAG!\r\u0001\u0017qR\u0005\u0004\u0003#\u0013!a\u0002-mIN\u0003Xm\u0019\u0005\b\u0003+\u0003A\u0011BAL\u0003A1\u0018\r\\5eCR,7i\\7nC:$7\u000f\u0006\u0003\u0002\u0000\u0005e\u0005\u0002CAN\u0003'\u0003\r!!(\u0002\u0011\r|W.\\1oIN\u0004RA`A\t\u0003?\u00032!OAQ\u0013\r\t\u0019K\u000f\u0002\u0012\t\u0016\u0004Hn\\=gS2,7i\\7nC:$\u0007bBAT\u0001\u0011%\u0011\u0011V\u0001\u000fGJ,\u0017\r^3D_6l\u0017M\u001c3t)!\tY+!/\u0002<\u0006u\u0006CBAW\u0003o\u000by*\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003%IW.\\;uC\ndWM\u0003\u0003\u00026\u0006=\u0011AC2pY2,7\r^5p]&!\u00111CAX\u0011!\ti#!*A\u0002\u0005=\u0002\u0002CAE\u0003K\u0003\r!a#\t\u0011\u0005M\u0013Q\u0015a\u0001\u0003+Bq!!1\u0001\t\u0013\t\u0019-A\bsKN|WO]2f\u00072,\u0017M\\+q)\u0011\ty(!2\t\u0011\u0005M\u0013q\u0018a\u0001\u0003+Bq!!3\u0001\t\u0013\tY-A\tg_J\fE\u000e\u001c#je\u0016\u001cGo\u001c:jKN$B!!4\u0002bR!\u0011qPAh\u0011!\t\t.a2A\u0002\u0005M\u0017!C2p]\u0012LG/[8o!!\t\t)!6\u0002Z\u0006}\u0014\u0002BAl\u0003\u001f\u0011\u0011BR;oGRLwN\\\u0019\u0011\u000by\f\t\"a7\u0011\u0007\u0001\fi.C\u0002\u0002`\n\u0011Q\u0002R5sK\u000e$xN]=Ta\u0016\u001c\u0007\u0002CAE\u0003\u000f\u0004\r!a#\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\u0006\u0011bm\u001c:BY2\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8t)\u0011\tI/!>\u0015\t\u0005}\u00141\u001e\u0005\t\u0003#\f\u0019\u000f1\u0001\u0002nBA\u0011\u0011QAk\u0003_\fy\bE\u0002a\u0003cL1!a=\u0003\u0005=\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Ta\u0016\u001c\u0007\u0002CAE\u0003G\u0004\r!a#\t\u000f\u0005e\b\u0001\"\u0003\u0002|\u0006i2\r[3dWB+'/\\5tg&|gNR8s\u0003B\u0004H.[2bi&|g\u000e\u0006\u0003\u0002\u0000\u0005u\b\u0002CA\u0000\u0003o\u0004\r!a<\u0002\u0007\u0005\u0004\b\u000fC\u0004\u0003\u0004\u0001!\tA!\u0002\u0002;\rDWmY6QKJl\u0017n]:j_:4uN\u001d#je\u0016\u001cGo\u001c:jKN$B!a \u0003\b!A!\u0011\u0002B\u0001\u0001\u0004\tI.\u0001\u0003eSJ\u001c\bb\u0002B\u0007\u0001\u0011\u0005!qB\u0001\u001cG\",7m\u001b)fe6L7o]5p]\u001a{'\u000fR5sK\u000e$xN]=\u0015\t\u0005}$\u0011\u0003\u0005\t\u0005'\u0011Y\u00011\u0001\u0002\\\u0006\u0019A-\u001b:\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a\u0005q2\r[3dWN+7-\u001e:jif\u0004VM]7jgNLwN\u001c$peV\u001bXM\u001d\u000b\u0005\u0003\u007f\u0012Y\u0002\u0003\u0005\u0003\n\tU\u0001\u0019AAm\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005C\tAbY1ti\u0006sGm\u00115fG.,BAa\t\u0003*Q1!Q\u0005B%\u0005\u001b\u0002BAa\n\u0003*1\u0001A\u0001\u0003B\u0016\u0005;\u0011\rA!\f\u0003\u0003Q\u000bBAa\f\u00036A!\u0011\u0011\u0011B\u0019\u0013\u0011\u0011\u0019$a\u0004\u0003\u000f9{G\u000f[5oOB!!q\u0007B#\u001b\t\u0011ID\u0003\u0003\u0003<\tu\u0012aA;e[*!!q\bB!\u0003\r\t\u0007/\u001b\u0006\u0004\u0005\u0007\"\u0011A\u00029mk\u001eLg.\u0003\u0003\u0003H\te\"!E\"p]\u001aLw-\u001e:bi&|g.\u0013;f[\"A!1\nB\u000f\u0001\u0004\u0011)$\u0001\u0002dS\"A!q\nB\u000f\u0001\u0004\u0011\t&A\u0003dY\u0006T(\u0010\u0005\u0004\u0002\u001a\tM#QE\u0005\u0005\u0005+\n)CA\u0003DY\u0006\u001c8\u000fC\u0005\u0003Z\u0001\t\n\u0011\"\u0001\u0003\\\u0005\tBm\\!qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tu#\u0006BA+\u0005?Z#A!\u0019\u0011\t\t\r$1N\u0007\u0003\u0005KRAAa\u001a\u0003j\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004E\u0005=\u0011\u0002\u0002B7\u0005K\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00111\u0011\t\b\u0001I\u0001\u0002\u0003\u0005I\u0011\u0001B:\u0003e\u0001(o\u001c;fGR,G\rJ2iK\u000e\\\u0007+\u001a:nSN\u001c\u0018n\u001c8\u0015\t\tU$\u0011\u0014\u000b\u0007\u0003\u007f\u00129Ha#\t\u0015\te$qNA\u0001\u0002\u0004\u0011Y(A\u0002yIE\u0002BA! \u0003\b6\u0011!q\u0010\u0006\u0005\u0005\u0003\u0013\u0019)\u0001\u0006qKJl\u0017n]:j_:T1A!\"\u0005\u0003!\u0019XmY;sSRL\u0018\u0002\u0002BE\u0005\u007f\u0012!\u0002U3s[&\u001c8/[8o\u0011)\u0011iIa\u001c\u0002\u0002\u0003\u0007!qR\u0001\u0004q\u0012\u0012\u0004\u0003\u0002BI\u0005/k!Aa%\u000b\t\tU\u0015QL\u0001\u0005Y\u0006tw-\u0003\u0003\u0002$\tM\u0005\"\u0003B=\u0005_\n\t\u00111\u0001`Q\r\u0001!Q\u0014\t\u0005\u0005?\u0013)+\u0004\u0002\u0003\"*\u0019!1U\u0014\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003(\n\u0005&!C\"p[B|g.\u001a8u\u0001")
public class DeployfileProcessor
extends AbstractSecuredResource {
    @Autowired
    private final RepositoryService repositoryService;
    @Autowired
    private final DeployfileGenerator deployfileGenerator;
    @Autowired
    private final DeployfileExecutor deployfileExecutor;
    @Autowired
    private final DeployfileResolver deployfileResolver;
    @Autowired
    private final CiCommandCreator commandCreator;
    @Autowired
    private final CommandExecutor commandExecutor;
    @Autowired
    private final Validator validator;
    private final Logger logger;

    public /* synthetic */ void protected$checkPermission(DeployfileProcessor x$1, Permission x$12, String x$2) {
        x$1.checkPermission(x$12, x$2);
    }

    private Logger logger() {
        return this.logger;
    }

    public List<String> doApply(String deployFile, Seq<InputPart> artifacts, File resourceDirectory) {
        List<String> list;
        List<XldSpec> xldSpecs = this.deployfileExecutor.execute(deployFile);
        this.validateXldSpec(xldSpecs);
        List<DeployfileCommand> commands = this.createCommands(artifacts, xldSpecs, resourceDirectory);
        this.validateCommands(commands);
        try {
            list = this.commandExecutor.execute(commands);
        }
        finally {
            this.resourceCleanUp(resourceDirectory);
        }
        return list;
    }

    public File doApply$default$3() {
        return Files.createTempDir();
    }

    public String doGenerate(java.util.List<String> folders) {
        java.util.List configurationItems = this.repositoryService.read(folders, 0, false);
        ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(folders).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.protected$checkPermission(this, DeployitPermissions.GENERATE_DEPLOY_FILE, x$1);
            return BoxedUnit.UNIT;
        });
        List directories = ((TraversableOnce)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(configurationItems).map((Function1 & Serializable & scala.Serializable)x$2 -> this.castAndCheck((ConfigurationItem)x$2, (Class)Directory.class), Buffer$.MODULE$.canBuildFrom())).toList();
        return this.deployfileGenerator.generate((List<Directory>)directories);
    }

    private void validateXldSpec(List<XldSpec> xldSpecs) {
        this.forAllApplications(xldSpecs, (Function1<ApplicationSpec, BoxedUnit>)(Function1 & Serializable & scala.Serializable)app -> {
            this.checkPermissionForApplication(app);
            return BoxedUnit.UNIT;
        });
        this.forAllDirectories(xldSpecs, (Function1<List<DirectorySpec>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dirs -> {
            DeployfileProcessor.$anonfun$validateXldSpec$2(this, dirs);
            return BoxedUnit.UNIT;
        });
    }

    private void validateCommands(List<DeployfileCommand> commands) {
        this.validator.validateCis(new ArrayList(ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)commands.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            DeployfileCommand deployfileCommand = x0$1;
            if (deployfileCommand instanceof DeleteCiCommand) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else if (deployfileCommand instanceof CiCommand) {
                CiCommand ciCommand = (CiCommand)deployfileCommand;
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ciCommand.ci()));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom()))));
    }

    private List<DeployfileCommand> createCommands(Seq<InputPart> artifacts, List<XldSpec> xldSpecs, File resourceDirectory) {
        return (List)xldSpecs.flatMap((Function1 & Serializable & scala.Serializable)spec -> {
            $this.deployfileResolver.resolveApplications((XldSpec)spec, artifacts, resourceDirectory);
            $this.deployfileResolver.resolveDefinitions((XldSpec)spec, artifacts, resourceDirectory);
            return $this.commandCreator.create((XldSpec)spec);
        }, List$.MODULE$.canBuildFrom());
    }

    private void resourceCleanUp(File resourceDirectory) {
        try {
            if (resourceDirectory.isDirectory()) {
                GuavaFiles.deleteRecursively((File)resourceDirectory);
            }
        }
        catch (IOException e) {
            this.logger().error("Could not clean up temporary directory {}", new Object[]{resourceDirectory});
        }
    }

    private void forAllDirectories(List<XldSpec> xldSpecs, Function1<List<DirectorySpec>, BoxedUnit> condition) {
        ((List)((List)xldSpecs.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(x$3.getDefinitions()), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getForDirectories(), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)dirs -> {
            DeployfileProcessor.$anonfun$forAllDirectories$3(condition, dirs);
            return BoxedUnit.UNIT;
        });
    }

    private void forAllApplications(List<XldSpec> xldSpecs, Function1<ApplicationSpec, BoxedUnit> condition) {
        ((List)xldSpecs.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(x$6.getApplications()), List$.MODULE$.canBuildFrom())).foreach(condition);
    }

    private void checkPermissionForApplication(ApplicationSpec app) {
        java.util.List<ConfigurationItemData> configurationItemDatas = this.deployfileResolver.lookInRepository((Application)app.getCi());
        String idToCheck = configurationItemDatas.isEmpty() ? ((BaseConfigurationItem)app.getCi()).getId() : configurationItemDatas.get(0).getId();
        this.checkPermission(PlatformPermissions.EDIT_REPO, PathHelper.getParentId((String)idToCheck));
    }

    public void checkPermissionForDirectories(List<DirectorySpec> dirs) {
        dirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            this.checkPermissionForDirectory(dir);
            return BoxedUnit.UNIT;
        });
    }

    public void checkPermissionForDirectory(DirectorySpec dir) {
        block0: {
            if (dir.getId() == null) break block0;
            String idToCheck = this.repositoryService.exists(dir.getId()) ? dir.getId() : PathHelper.getParentId((String)dir.getId());
            this.checkPermission(PlatformPermissions.EDIT_REPO, idToCheck);
        }
    }

    public void checkSecurityPermissionForUser(List<DirectorySpec> dirs) {
        block0: {
            if (!((TraversableOnce)dirs.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getPermissions(), List$.MODULE$.canBuildFrom())).nonEmpty()) break block0;
            this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        }
    }

    private <T extends ConfigurationItem> T castAndCheck(ConfigurationItem ci, Class<T> clazz) {
        Checks.checkArgument((boolean)clazz.isAssignableFrom(ci.getClass()), (String)"%s is not a %s", (Object[])new Object[]{ci, clazz.getSimpleName()});
        return (T)((ConfigurationItem)clazz.cast(ci));
    }

    public static final /* synthetic */ void $anonfun$validateXldSpec$2(DeployfileProcessor $this, List dirs) {
        $this.checkPermissionForDirectories((List<DirectorySpec>)dirs);
        $this.checkSecurityPermissionForUser((List<DirectorySpec>)dirs);
    }

    public static final /* synthetic */ void $anonfun$forAllDirectories$3(Function1 condition$1, ForDirectories dirs) {
        List list = Option$.MODULE$.apply((Object)dirs.getForEnvironments()).toList();
        List specs = Option$.MODULE$.apply((Object)dirs.getForInfrastructure()).toList().$colon$colon$colon(list);
        condition$1.apply((Object)specs);
    }

    public DeployfileProcessor(@Autowired RepositoryService repositoryService, @Autowired DeployfileGenerator deployfileGenerator, @Autowired DeployfileExecutor deployfileExecutor, @Autowired DeployfileResolver deployfileResolver, @Autowired CiCommandCreator commandCreator, @Autowired CommandExecutor commandExecutor, @Autowired Validator validator) {
        this.repositoryService = repositoryService;
        this.deployfileGenerator = deployfileGenerator;
        this.deployfileExecutor = deployfileExecutor;
        this.deployfileResolver = deployfileResolver;
        this.commandCreator = commandCreator;
        this.commandExecutor = commandExecutor;
        this.validator = validator;
        this.logger = LoggerFactory.getLogger(DeployfileProcessor.class);
    }
}

