package com.xebialabs.ascode.yaml.sugar

import com.xebialabs.deployit.plugin.api.reflect.{PropertyDescriptor, Type}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

import scala.collection.convert.ImplicitConversions._

object Sugarizer {

  implicit class SugarizedType(ciType: Type) {
    def getAllRelatedSugarDescriptors(implicit sugarConfig: SugarConfig): List[SugarDescriptor] = {
      val ciDescriptor = ciType.getDescriptor
      (ciType :: ciDescriptor.getSuperClasses.toList ::: ciDescriptor.getInterfaces.toList)
        .flatMap { current =>
          sugarConfig
            .typeToDescriptors
            .find { case (t, _) => current == t }
            .map { case (_, descriptor) => descriptor }
        }
    }

    def getClosestTypeSugar(implicit sugarConfig: SugarConfig): Option[SugarDescriptor] =
      ciType.getAllRelatedSugarDescriptors.headOption

    def getFieldSugaringAction(field: String)(implicit sugarConfig: SugarConfig): Option[Action] =
      getAllRelatedSugarDescriptors
        .flatMap(_.findSugaringAction(field))
        .headOption

    def isFieldRemovedBySugar(field: String)(implicit sugarConfig: SugarConfig): Boolean =
      getFieldSugaringAction(field).exists {
        case Add(_, _) => false
        case _ => true
      }
  }

  implicit class SugarizedDescriptor(propertyDescriptor: PropertyDescriptor) {
    def isWhitelisted(ci: ConfigurationItem)(implicit sugarConfig: SugarConfig): Boolean =
      sugarConfig
        .typeToDescriptors
        .find { case (ciType, _) => ci.getType.instanceOf(ciType) }
        .map { case (_, descriptor) => descriptor }
        .orElse(sugarConfig.typeToDescriptors.get(ci.getType))
        .exists(_.whitelistedFields.contains(propertyDescriptor.getName))
  }

  def writeWithSugar(field: String, value: String)
                    (implicit sugarConfig: SugarConfig, ciType: Type): Option[(String, String)] = {
    ciType.getFieldSugaringAction(field) match {
      case Some(action) => action match {
        case Change(_, replaceFieldName) => Some(replaceFieldName -> value)
        case Add(_, _) => Some(field -> value)
        case Remove(_) => None
      }
      case None => Some(field -> value)
    }
  }
}
