package com.xebialabs.deployit.core.rest

import com.xebialabs.ascode.exception.{AsCodeException, CiPermissionException, CiValidationException, DocumentValidationException}
import com.xebialabs.ascode.yaml.dto.AsCodeResponse
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.Errors
import javax.ws.rs.Produces
import javax.ws.rs.core.{MediaType, Response}
import javax.ws.rs.ext.{ExceptionMapper, Provider}
import org.slf4j.{Logger, LoggerFactory}
import org.springframework.stereotype.Component

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class AsCodeExceptionMapper extends ExceptionMapper[AsCodeException] {
  protected val logger: Logger = LoggerFactory.getLogger(getClass)

  override def toResponse(exception: AsCodeException): Response = {
    logger.info(getClass.getName, exception.getCause)
    val response = exception match {
      case CiPermissionException(errors) => AsCodeResponse.errors(Errors(permission = errors))
      case CiValidationException(errors) => AsCodeResponse.errors(Errors(validation = errors))
      case DocumentValidationException(error) => AsCodeResponse.errors(Errors(document = Some(error)))
      case e => AsCodeResponse.errors(Errors(generic = Some(Option(e.getCause).getOrElse(e).getMessage)))
    }
    Response.status(400).entity(response).`type`(MediaType.APPLICATION_JSON).build()
  }
}
