package com.xebialabs.ascode.service.spec

import com.xebialabs.ascode.yaml.dto.AsCodeResponse
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.ChangedIds
import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData

object SpecInterpreter {
  def compose(specInterpreters: Iterable[SpecInterpreter]): PartialFunction[InterpreterContext, AsCodeResponse] = {
    specInterpreters.reduceLeft[PartialFunction[InterpreterContext, AsCodeResponse]]((left, right) => left.orElse(right))
  }

  def createOrUpdate[T, R](entities: List[T],
                           defaultIds: ChangedIds,
                           extractLabel: R => String,
                           prepare: T => R,
                           create: R => R,
                           update: R => R
                          ): ChangedIds = {
    entities.foldLeft(defaultIds) { case (ids, entity) =>
      val toPersist = prepare(entity)
      try {
        val created = create(toPersist)
        ids.withCreated(extractLabel(created))
      } catch {
        case _: IllegalArgumentException =>
          val updated = update(toPersist)
          ids.withUpdated(extractLabel(updated))
      }
    }
  }

  def delete[T, R](entities: List[T],
                   defaultIds: ChangedIds,
                   extractLabel: R => String,
                   prepare: T => R,
                   delete: R => R
                  ): ChangedIds = {
    entities.foldLeft(defaultIds) { case (ids, entity) =>
      val toPersist = prepare(entity)
      val deleted = delete(toPersist)
      ids.withDeleted(extractLabel(deleted))
    }
  }
}

case class InterpreterContext(definition: Definition, scmTraceabilityData: Option[SCMTraceabilityData] = None)

trait SpecInterpreter extends PartialFunction[InterpreterContext, AsCodeResponse]