package com.xebialabs.ascode.yaml.model.permission

import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonInclude.Include
import com.fasterxml.jackson.databind.JsonNode
import com.xebialabs.ascode.yaml.parser.util.JsonNodeSugar._

object RolePermissionsRelation {
  def parse(node: JsonNode): RolePermissionsRelation = {
    val role = node.requiredString("role")
    val permissions = node.listOfStrings("permissions")
    RolePermissionsRelation(role, permissions)
  }
}

case class RolePermissionsRelation(role: String, @JsonInclude(Include.NON_EMPTY) permissions: List[String]) extends PermissionRelation