/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.ascode.yaml.parser;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.Specs;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.parser.DefinitionParser$;
import com.xebialabs.ascode.yaml.parser.SpecParser;
import com.xebialabs.deployit.core.rest.YamlSupport;
import java.io.InputStream;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Es!\u0002\b\u0010\u0011\u0003Qb!\u0002\u000f\u0010\u0011\u0003i\u0002\"\u0002\u0013\u0002\t\u0003)\u0003\"\u0002\u0014\u0002\t\u00039\u0003\"B'\u0002\t\u0003qe\u0001\u0002\u000f\u0010\u0001AC\u0001BJ\u0003\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006I\u0015!\ta\u0017\u0005\u0006;\u0016!IA\u0018\u0005\u0006e\u0016!Ia\u001d\u0005\b\u0003\u001f)A\u0011AA\t\u0011\u001d\ti\"\u0002C\u0005\u0003?Aq!a\r\u0006\t\u0003\t)\u0004C\u0004\u00024\u0015!\t!a\u0012\u0002!\u0011+g-\u001b8ji&|g\u000eU1sg\u0016\u0014(B\u0001\t\u0012\u0003\u0019\u0001\u0018M]:fe*\u0011!cE\u0001\u0005s\u0006lGN\u0003\u0002\u0015+\u00051\u0011m]2pI\u0016T!AF\f\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\r\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005m\tQ\"A\b\u0003!\u0011+g-\u001b8ji&|g\u000eU1sg\u0016\u00148CA\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AG\u0001\u0006gB,7m\u001d\u000b\u0004Q=b\u0004cA\u0015+Y5\t\u0011#\u0003\u0002,#\t)1\u000b]3dgB\u00111$L\u0005\u0003]=\u0011!b\u00159fGB\u000b'o]3s\u0011\u0015\u00014\u00011\u00012\u0003\u001d\u0001(o\u001c3vGR\u0004\"AM\u001d\u000f\u0005M:\u0004C\u0001\u001b!\u001b\u0005)$B\u0001\u001c\u001a\u0003\u0019a$o\\8u}%\u0011\u0001\bI\u0001\u0007!J,G-\u001a4\n\u0005iZ$AB*ue&twM\u0003\u00029A!)Qh\u0001a\u0001}\u0005Y1\u000f]3d!\u0006\u00148/\u001a:t!\ryr(Q\u0005\u0003\u0001\u0002\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?!\u0011y\"\t\u0012\u0017\n\u0005\r\u0003#A\u0002+va2,'\u0007E\u0002F\u0015Fr!A\u0012%\u000f\u0005Q:\u0015\"A\u0011\n\u0005%\u0003\u0013a\u00029bG.\fw-Z\u0005\u0003\u00172\u0013A\u0001T5ti*\u0011\u0011\nI\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u001f\u00065\u0013q\n\t\u00037\u0015\u00192!\u0002\u0010R!\t\u0011\u0016,D\u0001T\u0015\t!V+\u0001\u0003sKN$(B\u0001,X\u0003\u0011\u0019wN]3\u000b\u0005a+\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005i\u001b&aC-b[2\u001cV\u000f\u001d9peR$\"a\u0014/\t\u000b\u0019:\u0001\u0019\u0001\u0015\u0002\u001fA\f'o]3EK\u001aLg.\u001b;j_:$\"aX3\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t\f\u0012!B7pI\u0016d\u0017B\u00013b\u0005)!UMZ5oSRLwN\u001c\u0005\u0006M\"\u0001\raZ\u0001\u0005]>$W\r\u0005\u0002ia6\t\u0011N\u0003\u0002gU*\u00111\u000e\\\u0001\tI\u0006$\u0018MY5oI*\u0011QN\\\u0001\bU\u0006\u001c7n]8o\u0015\tyw#A\u0005gCN$XM\u001d=nY&\u0011\u0011/\u001b\u0002\u000b\u001f\nTWm\u0019;O_\u0012,\u0017aC4fi6+G/\u00193bi\u0006$2\u0001^A\u0007!\ryRo^\u0005\u0003m\u0002\u0012aa\u00149uS>t\u0007\u0003\u0002=~\u007f~l\u0011!\u001f\u0006\u0003un\f\u0011\"[7nkR\f'\r\\3\u000b\u0005q\u0004\u0013AC2pY2,7\r^5p]&\u0011a0\u001f\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005Y\u0006twM\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\rQ\u00141\u0001\u0005\u0006M&\u0001\raZ\u0001\u0019O\u0016$\b+\u0019:tK\u0016C8-\u001a9uS>tW*Z:tC\u001e,GcA\u0019\u0002\u0014!9\u0011Q\u0003\u0006A\u0002\u0005]\u0011!A3\u0011\u0007\u0015\u000bI\"C\u0002\u0002\u001c1\u0013\u0011\u0002\u00165s_^\f'\r\\3\u0002\u0013A\f'o]3ZC6dGcA0\u0002\"!9\u00111E\u0006A\u0002\u0005\u0015\u0012AC=b[2\u0004\u0016M]:feB!\u0011qEA\u0018\u001b\t\tICC\u0002\u0013\u0003WQ1!!\fm\u0003)!\u0017\r^1g_Jl\u0017\r^\u0005\u0005\u0003c\tIC\u0001\u0006Z\u00036c\u0005+\u0019:tKJ\fQ\u0001]1sg\u0016$2aXA\u001c\u0011\u001d\tI\u0004\u0004a\u0001\u0003w\taa\u001d;sK\u0006l\u0007\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\t\u0005\u0005\u0013qA\u0001\u0003S>LA!!\u0012\u0002@\tY\u0011J\u001c9viN#(/Z1n)\ry\u0016\u0011\n\u0005\u0007\u0003\u0017j\u0001\u0019A\u0019\u0002\rM$(/\u001b8h\u0011\u0015\u0001D\u00011\u00012\u0011\u0015iD\u00011\u0001?\u0001")
public class DefinitionParser
implements YamlSupport {
    private final Specs<SpecParser> specs;
    private YAMLFactory yamlFactory;
    private YAMLMapper yamlMapper;

    public static DefinitionParser apply(String product, Seq<Tuple2<List<String>, SpecParser>> specParsers) {
        return DefinitionParser$.MODULE$.apply(product, specParsers);
    }

    @Override
    public YAMLFactory yamlFactory() {
        return this.yamlFactory;
    }

    @Override
    public YAMLMapper yamlMapper() {
        return this.yamlMapper;
    }

    @Override
    public void com$xebialabs$deployit$core$rest$YamlSupport$_setter_$yamlFactory_$eq(YAMLFactory x$1) {
        this.yamlFactory = x$1;
    }

    @Override
    public void com$xebialabs$deployit$core$rest$YamlSupport$_setter_$yamlMapper_$eq(YAMLMapper x$1) {
        this.yamlMapper = x$1;
    }

    private Definition parseDefinition(ObjectNode node) {
        if (!node.has("apiVersion") || node.get("apiVersion").isNull()) {
            throw AsCodeException$.MODULE$.throwDocumentFieldException("apiVersion", "Document is missing an apiVersion definition");
        }
        String apiVersion = node.get("apiVersion").asText();
        if (apiVersion.isEmpty() || apiVersion.indexOf(47) == -1) {
            throw AsCodeException$.MODULE$.throwDocumentFieldException("apiVersion", "apiVersion format invalid: " + Option$.MODULE$.apply((Object)apiVersion).getOrElse((Function0 & Serializable)() -> ""));
        }
        String project = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(apiVersion), '/')));
        if (!node.has("kind") || node.get("kind").isNull()) {
            throw AsCodeException$.MODULE$.throwDocumentFieldException("kind", "Document is missing a kind definition");
        }
        String kind = node.get("kind").asText();
        SpecParser specParser = this.specs.getSpec(project, kind);
        if (!node.has("spec") || node.get("spec").isNull()) {
            throw AsCodeException$.MODULE$.throwDocumentFieldException("spec", "Document is missing a spec definition");
        }
        Option<Map<String, String>> metadata = this.getMetadata(node);
        return new Definition(apiVersion, metadata, kind, specParser.parse(kind, metadata, node.get("spec"), (ObjectMapper)this.yamlMapper()));
    }

    private Option<Map<String, String>> getMetadata(ObjectNode node) {
        return Option$.MODULE$.apply((Object)node.get("metadata")).map((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.IteratorHasAsScala(x$1.fields()).asScala().map((Function1 & Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(field.getKey()), (Object)((JsonNode)field.getValue()).asText(null))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public String getParseExceptionMessage(Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof JsonParseException) {
            JsonParseException jsonParseException = (JsonParseException)throwable;
            return jsonParseException.getOriginalMessage() + " at line number: " + jsonParseException.getLocation().getLineNr();
        }
        if (throwable.getCause() != null) {
            return this.getParseExceptionMessage(throwable.getCause());
        }
        return throwable.getMessage();
    }

    private Definition parseYaml(YAMLParser yamlParser) {
        boolean bl = false;
        Success success = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> CollectionConverters$.MODULE$.IteratorHasAsScala(yamlParser.readValuesAs(ObjectNode.class)).asScala().toList());
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            List list = (List)success.value();
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                ObjectNode document = (ObjectNode)colon2.head();
                List list2 = colon2.next$access$1();
                if (Nil$.MODULE$.equals(list2)) {
                    return this.parseDefinition(document);
                }
            }
        }
        if (bl) {
            throw new AsCodeException("This endpoint handles only one document per request.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw new AsCodeException(this.getParseExceptionMessage(e), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError((Object)try_);
    }

    public Definition parse(InputStream stream) {
        return this.parseYaml(this.yamlFactory().createParser(stream));
    }

    public Definition parse(String string) {
        return this.parseYaml(this.yamlFactory().createParser(string));
    }

    public DefinitionParser(Specs<SpecParser> specs) {
        this.specs = specs;
        YamlSupport.$init$(this);
        Statics.releaseFence();
    }
}

