package com.xebialabs.ascode.yaml.model

class User(val username: String, val password: String) {
  override def equals(obj: Any): Boolean = obj match {
    case user: User => this.username == user.username && this.password == user.password
    case _ => false
  }
}

object User {
  def apply(username: String, password: String) = new User(username, password)
}

case class UsersSpec(users: List[User]) extends Spec
