package com.xebialabs.ascode.yaml.writer.support.descriptor

import java.lang.annotation.Annotation
import java.util
import java.util.function
import com.xebialabs.deployit.plugin.api.reflect.{DescriptorRegistryId, InputHint, PropertyDescriptor, PropertyKind, Type}
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, Property}

case class CustomPropertyDescriptor(typeSource: DescriptorRegistryId,
                                    delegate: Option[PropertyDescriptor] = None,
                                    name: Option[String] = None,
                                    description: Option[String] = None,
                                    asContainment: Option[Boolean] = None,
                                    nested: Option[Boolean] = None,
                                    order: Option[Int] = None,
                                    category: Option[String] = None,
                                    label: Option[String] = None,
                                    password: Option[Boolean] = None,
                                    required: Option[Boolean] = None,
                                    size: Option[Property.Size] = None,
                                    kind: Option[PropertyKind] = None,
                                    enumValues: Option[util.List[String]] = None,
                                    referencedType: Option[Type] = None,
                                    defaultValue: Option[AnyRef] = None,
                                    hidden: Option[Boolean] = None,
                                    equal: Option[Boolean] = None,
                                    inspectionProperty: Option[Boolean] = None,
                                    requiredForInspection: Option[Boolean] = None,
                                    transient: Option[Boolean] = None,
                                    aliases: Option[util.Set[String]] = None,
                                    candidateValuesFilter: Option[String] = None,
                                    fqn: Option[String] = None,
                                    deployedSpecific: Option[Boolean] = None,
                                    inputHint: Option[InputHint] = None,
                                    value: Option[AnyRef] = None,
                                    readOnly: Option[Boolean] = None,
                                    annotation: Option[util.List[Annotation]] = None) extends PropertyDescriptor {
  override def getName: String = name.orElse(delegate.map(_.getName)).orNull

  override def getDescription: String = description.orElse(delegate.map(_.getDescription)).orNull

  override def isAsContainment: Boolean = asContainment.orElse(delegate.map(_.isAsContainment)).getOrElse(false)

  override def isNested: Boolean = nested.orElse(delegate.map(_.isNested)).getOrElse(false)

  override def getCategory: String = category.orElse(delegate.map(_.getCategory)).orNull

  override def getLabel: String = label.orElse(delegate.map(_.getLabel)).orNull

  override def isPassword: Boolean = password.orElse(delegate.map(_.isPassword)).getOrElse(false)

  override def isRequired: Boolean = required.orElse(delegate.map(_.isRequired)).getOrElse(false)

  override def getSize: Property.Size = size.orElse(delegate.map(_.getSize)).orNull

  override def getKind: PropertyKind = kind.orElse(delegate.map(_.getKind)).orNull

  override def getEnumValues: util.List[String] = enumValues.orElse(delegate.map(_.getEnumValues)).orNull

  override def getReferencedType: Type = referencedType.orElse(delegate.map(_.getReferencedType)).orNull

  override def getDefaultValue: AnyRef = defaultValue.orElse(delegate.map(_.getDefaultValue)).orNull

  override def isHidden: Boolean = hidden.orElse(delegate.map(_.isHidden)).getOrElse(false)

  override def get(item: ConfigurationItem): AnyRef = value.orElse(delegate.map(_.get(item))).orNull

  override def set(item: ConfigurationItem, value: Any): Unit = delegate.foreach(_.set(item, value))

  override def areEqual(item: ConfigurationItem, other: ConfigurationItem): Boolean =
    equal.orElse(delegate.map(_.areEqual(item, other))).getOrElse(false)

  override def areEqual(item: ConfigurationItem,
                        other: ConfigurationItem,
                        identifierExtractor: function.Function[ConfigurationItem, AnyRef]): Boolean =
    equal.orElse(delegate.map(_.areEqual(item, other, identifierExtractor))).getOrElse(false)

  override def isInspectionProperty: Boolean =
    inspectionProperty.orElse(delegate.map(_.isInspectionProperty)).getOrElse(false)

  override def isRequiredForInspection: Boolean =
    requiredForInspection.orElse(delegate.map(_.isRequiredForInspection)).getOrElse(false)

  override def isTransient: Boolean =
    transient.orElse(delegate.map(_.isTransient)).getOrElse(false)

  override def getAliases: util.Set[String] = aliases.orElse(delegate.map(_.getAliases)).orNull

  override def getCandidateValuesFilter: String =
    candidateValuesFilter.orElse(delegate.map(_.getCandidateValuesFilter)).orNull

  override def getFqn: String = fqn.orElse(delegate.map(_.getFqn)).orNull

  override def isDeployedSpecific: Boolean = deployedSpecific.orElse(delegate.map(_.isDeployedSpecific)).getOrElse(false)

  override def getInputHint: InputHint = inputHint.orElse(delegate.map(_.getInputHint)).orNull

  override def isReadonly: Boolean = readOnly.orElse(delegate.map(_.isReadonly)).getOrElse(false)

  override def getAnnotations: util.List[Annotation] = annotation.orElse(delegate.map(_.getAnnotations)).orNull

  override def getTypeSource: DescriptorRegistryId = typeSource

  override def getOrder: Int =  order.orElse(delegate.map(_.getOrder)).getOrElse(0)
}
