package com.xebialabs.ascode.yaml.parser

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.ascode.yaml.model.{Role, RolesSpec, Spec}
import com.xebialabs.ascode.yaml.parser.util.JsonNodeSugar._

import scala.collection.convert.ImplicitConversions._

object RolesSpecParser extends SpecParser {
  override def parse(definitionKind: String, metadata: Option[Map[String, String]], node: JsonNode)
                    (implicit mapper: ObjectMapper): Spec = {
    val roles = node.elements().map { element =>
      val name = element.requiredString("name")
      val principals = element.listOfStrings("principals").toSet
      Role(name, principals)
    }.toList

    RolesSpec(roles)
  }
}
