package com.xebialabs.deployit.ascode.service.generator

import com.xebialabs.ascode.yaml.model.{Definition, Role, RolesSpec}
import com.xebialabs.deployit.ascode.service.generator.DefinitionGeneratorService.GeneratorConfig
import com.xebialabs.deployit.ascode.yaml.model.Constants.Kinds._
import com.xebialabs.deployit.ascode.yaml.model.Constants.Versions._
import com.xebialabs.deployit.core.rest.api.RoleResource
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Autowired
class RolesGenerator(roleResource: RoleResource) extends DefinitionGenerator {
  override def generate(config: GeneratorConfig, cis: List[ConfigurationItem]): List[Definition] = {
    if (config.roles) {
      val roles = roleResource
        .readRolePrincipals()
        .asScala
        .map(rolePrincipals => Role(rolePrincipals.getRole.getName, rolePrincipals.getPrincipals.asScala.toSet))
        .toList

      if (roles.nonEmpty) {
        Definition(XLD_API_VERSION, None, ROLES, RolesSpec(roles)) :: Nil
      } else Nil
    } else Nil
  }
}
