package com.xebialabs.deployit.ascode.yaml.parser.spec.ci

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.utils.TypeSugar._
import com.xebialabs.deployit.plugin.api.reflect.Descriptor
import com.xebialabs.deployit.plugin.api.udm._
import com.xebialabs.xltype.serialization.{CiReader, ConfigurationItemConverter}

class ConfigurationItemParser extends ConfigurationItemConverter {
  private var seenCiIds = Set[String]()
  var foundFiles: Map[String, String] = Map[String, String]()

  override def readCi(reader: CiReader): ConfigurationItem = {
    val ci = super.readCi(reader)
    val id = ci.getId
    if (seenCiIds.contains(id)) {
      AsCodeException.throwCiFieldValidationException(id, "name", "Duplicate CI id")
    }
    seenCiIds = seenCiIds + id
    ci
  }

  override def readProperty(reader: CiReader, descriptor: Descriptor, configurationItem: ConfigurationItem): Unit = {
    reader.getCurrentPropertyName match {
      case "children" => readCisOrReferences(reader.getCurrentCiListReader)
      case "file" if descriptor.getType.isArtifact => foundFiles = foundFiles + (reader.getId -> reader.getStringValue)
      case _ => super.readProperty(reader, descriptor, configurationItem)
    }
  }
}
