/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableSet;
import com.xebialabs.deployit.ci.bamboo.configuration.AbstractDeployitConfigurator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DeployAppConfigurator
extends AbstractDeployitConfigurator {
    private static final Logger log = Logger.getLogger(DeployAppConfigurator.class);
    public static final String DEPLOYIT_ENVIRONMENT = "deployitEnvironment";
    public static final String DEPLOYIT_APPLICATION = "deployitApplication";
    public static final String DEPLOYIT_VERSION = "deployitVersion";
    public static final String DEPLOYIT_LASTEST_VERSION = "deployitLastestVersion";
    public static final String DEPLOYIT_SKIP_STEPS = "deployitSkipSteps";
    public static final String DEPLOYIT_TEST_MODE = "deployitTestMode";
    private static final Set<String> FIELDS_TO_COPY = ImmutableSet.of((Object)"deployitEnvironment", (Object)"deployitApplication", (Object)"deployitVersion", (Object)"deployitLastestVersion", (Object)"deployitSkipSteps", (Object)"deployitTestMode", (Object[])new String[0]);

    @Override
    protected Set<String> getExtraFieldsToCopy() {
        return FIELDS_TO_COPY;
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(DEPLOYIT_LASTEST_VERSION, "true");
        context.put(DEPLOYIT_SKIP_STEPS, "false");
        context.put(DEPLOYIT_TEST_MODE, "false");
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        log.debug((Object)"DeployUpgradeConfigurator.validate");
        log.debug((Object)("params " + params));
        super.validate(params, errorCollection);
        this.validateAttribute(params, errorCollection, DEPLOYIT_ENVIRONMENT, "deployit.environment.error");
        this.validateAttribute(params, errorCollection, DEPLOYIT_APPLICATION, "deployit.application.error");
        String lastestVersion = params.getString(DEPLOYIT_LASTEST_VERSION);
        String version = params.getString(DEPLOYIT_VERSION);
        if ("false".equals(lastestVersion) && StringUtils.isEmpty((String)version)) {
            errorCollection.addError(DEPLOYIT_LASTEST_VERSION, this.textProvider.getText("deployit.version.error"));
            errorCollection.addError(DEPLOYIT_VERSION, this.textProvider.getText("deployit.version.error"));
        }
    }
}

