/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.tasks;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.task.TaskContext;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.ci.bamboo.tasks.AbstractDeployitTask;
import com.xebialabs.deployit.ci.bamboo.util.Dirs;
import com.xebialabs.deployit.client.DeployitCli;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ImportApplicationTaskAbstract
extends AbstractDeployitTask {
    public ImportApplicationTaskAbstract(ErrorUpdateHandler errorUpdateHandler) {
        super(errorUpdateHandler);
    }

    @Override
    void doExecute(TaskContext taskContext, DeployitCli cli) {
        String darPath;
        HashSet importedDars = Sets.newHashSet();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        String extension = (String)configurationMap.get((Object)"deployitExtension");
        if (StringUtils.isNotBlank((String)extension)) {
            for (String archive : this.getDeploymentPackages(taskContext.getWorkingDirectory(), extension)) {
                this.importDar(new File(taskContext.getWorkingDirectory(), archive), cli, buildLogger);
                importedDars.add(archive);
            }
        }
        if (StringUtils.isNotBlank((String)(darPath = (String)configurationMap.get((Object)"deployitDarPath"))) && !importedDars.contains(darPath)) {
            this.importDar(new File(taskContext.getWorkingDirectory(), darPath), cli, buildLogger);
        }
    }

    private ConfigurationItem importDar(File darFile, DeployitCli cli, BuildLogger buildLogger) {
        buildLogger.addBuildLogEntry(String.format("Import '%s' ", darFile));
        ConfigurationItem importedPackaged = cli.importPackage(darFile.getAbsolutePath(), cli.getListener());
        buildLogger.addBuildLogEntry(String.format("Import of '%s' returned %s", darFile, importedPackaged));
        return importedPackaged;
    }

    private List<String> getDeploymentPackages(File directory, String packageExtension) {
        final String suffix = packageExtension.startsWith(".") ? packageExtension : "." + packageExtension;
        return Dirs.listRecursively(directory, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(suffix);
            }
        });
    }
}

