/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.tasks;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.task.TaskContext;
import com.xebialabs.deployit.ci.bamboo.tasks.AbstractDeployitTask;
import com.xebialabs.deployit.client.DeployitCli;

public class UndeployApplicationTaskAbstract
extends AbstractDeployitTask {
    public UndeployApplicationTaskAbstract(ErrorUpdateHandler errorUpdateHandler) {
        super(errorUpdateHandler);
    }

    @Override
    void doExecute(TaskContext taskContext, DeployitCli cli) {
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        String environmentName = (String)configurationMap.get((Object)"deployitEnvironment");
        String applicationName = (String)configurationMap.get((Object)"deployitApplication");
        String environment = String.format("Environments/%s/%s", environmentName, applicationName);
        buildLogger.addBuildLogEntry(String.format("Undeploying '%s' from environment '%s'", applicationName, environment));
        cli.undeployAndWait(environment);
        buildLogger.addBuildLogEntry("Application was successfully undeployed.");
    }
}

