/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.tasks;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.TaskContext;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.ci.bamboo.client.CiDeploy;
import com.xebialabs.deployit.ci.bamboo.client.ClientListener;
import com.xebialabs.deployit.ci.bamboo.client.DeployOptions;
import com.xebialabs.deployit.ci.bamboo.tasks.AbstractDeployitTask;

public class DeployApplicationTaskAbstract
extends AbstractDeployitTask
implements ClientListener {
    private BuildLogger buildLogger;

    @Override
    void doExecute(TaskContext taskContext, DeployitCommunicator communicator) {
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        this.buildLogger = taskContext.getBuildLogger();
        String environmentName = (String)configurationMap.get((Object)"deployitEnvironment");
        String applicationName = (String)configurationMap.get((Object)"deployitApplication");
        String version = (String)configurationMap.get((Object)"deployitVersion");
        String orchestrator = (String)configurationMap.get((Object)"deployitOrchestrator");
        String updateDeployeds = (String)configurationMap.get((Object)"deployitUpdateDeployeds");
        String failAction = (String)configurationMap.get((Object)"deployitFailAction");
        DeployOptions.FailAction action = DeployOptions.FailAction.Cancel;
        if (failAction.equalsIgnoreCase("Rollback")) {
            action = DeployOptions.FailAction.Rollback;
        } else if (failAction.equalsIgnoreCase("Nothing")) {
            action = DeployOptions.FailAction.Nothing;
        }
        String deploymentPackage = String.format("%s/%s", applicationName, version);
        String environment = environmentName;
        DeployOptions options = new DeployOptions(deploymentPackage, environment);
        options.setOrchestrator(orchestrator);
        options.setUpdateDeployeds(Boolean.valueOf(updateDeployeds));
        options.setOnFailure(action);
        CiDeploy deploy = new CiDeploy(communicator, this);
        deploy.deploy(options);
    }

    @Override
    public void info(String message) {
        this.buildLogger.addBuildLogEntry("[XL DEPLOY] " + message);
    }

    @Override
    public void error(String message) {
        this.buildLogger.addErrorLogEntry("[XL DEPLOY] " + message);
    }
}

