/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.thoughtworks.xstream.converters.Converter;
import com.xebialabs.deployit.booter.remote.xml.DescriptorConverter;
import com.xebialabs.deployit.booter.remote.xml.MethodDescriptorConverter;
import com.xebialabs.deployit.booter.remote.xml.PropertyDescriptorConverter;
import com.xebialabs.deployit.booter.remote.xml.RemoteXStreamCiConverter;
import com.xebialabs.deployit.booter.remote.xml.StepConverter;
import com.xebialabs.deployit.booter.remote.xml.TaskConverter;
import com.xebialabs.xltype.serialization.xstream.ConfigurationItemIdConverter;
import com.xebialabs.xltype.serialization.xstream.ControlConverter;
import com.xebialabs.xltype.serialization.xstream.DeploymentConverter;
import com.xebialabs.xltype.serialization.xstream.InspectionConverter;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.util.Collection;
import java.util.Set;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBooterConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteBooterConfigurer.class);
    protected static final Set<Class<? extends Converter>> XSTREAM_PROVIDER_CLASSES = ImmutableSet.of(RemoteXStreamCiConverter.class, DescriptorConverter.class, MethodDescriptorConverter.class, PropertyDescriptorConverter.class, StepConverter.class, TaskConverter.class, (Object[])new Class[]{ConfigurationItemIdConverter.class, ControlConverter.class, DeploymentConverter.class, InspectionConverter.class});

    public static void preconfigure() {
        Scannit.boot((Configuration)Configuration.config());
        for (Converter converter : RemoteBooterConfigurer.allConverters()) {
            LOGGER.debug("Registering XStream converter: {}", (Object)converter);
            XStreamReaderWriter.registerConverter((Converter)converter);
        }
    }

    private static Collection<Converter> allConverters() {
        return Collections2.transform(XSTREAM_PROVIDER_CLASSES, (Function)new Function<Class<? extends Converter>, Converter>(){

            public Converter apply(Class<? extends Converter> input) {
                Preconditions.checkArgument((boolean)Converter.class.isAssignableFrom(input));
                Converter conv = RemoteBooterConfigurer.getConverter(input);
                return conv;
            }
        });
    }

    private static Converter getConverter(Class<? extends Converter> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

