/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.collections.SimpleActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskConfiguratorHelper;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.opensymphony.xwork.TextProvider;
import com.xebialabs.deployit.ci.bamboo.util.CollectionUtils;
import com.xebialabs.deployit.ci.bamboo.util.EncryptionKeys;
import com.xebialabs.deployit.encryption.AESPasswordEncrypter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.dispatcher.HttpParameters;

public class AbstractDeployitConfigurator
extends AbstractTaskConfigurator {
    public static final String DEPLOYIT_URL = "deployitServerUrl";
    public static final String DEPLOYIT_USERNAME = "deployitUsername";
    public static final String DEPLOYIT_PASSWORD = "deployitPassword";
    private static final String CTX_UI_CONFIG_SUPPORT = "uiConfigSupport";
    private static final Logger log = Logger.getLogger(AbstractDeployitConfigurator.class);
    private static final AESPasswordEncrypter AES_PASSWORD_ENCRYPTER = new AESPasswordEncrypter(EncryptionKeys.DEFAULT_PASSWORD_ENCRYPTION_KEY);
    protected TextProvider textProvider;
    protected UIConfigSupport uiConfigSupport;
    private static final Set<String> FIELDS_TO_COPY = CollectionUtils.immutableSet("deployitServerUrl", "deployitUsername", "deployitPassword");
    @Inject
    private TaskConfiguratorHelper bambooTaskConfigurationHelper;

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContextForAllOperations(context);
        this.bambooTaskConfigurationHelper.populateContextWithConfiguration(context, taskDefinition, CollectionUtils.concatIterables(FIELDS_TO_COPY, this.getExtraFieldsToCopy()));
    }

    public void populateContextForView(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        this.populateContextForAllOperations(context);
        this.bambooTaskConfigurationHelper.populateContextWithConfiguration(context, taskDefinition, CollectionUtils.concatIterables(FIELDS_TO_COPY, this.getExtraFieldsToCopy()));
    }

    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateContextForAllOperations(context);
        context.put(DEPLOYIT_URL, "http://localhost:4516");
        context.put(DEPLOYIT_USERNAME, "admin");
    }

    public Set<Requirement> calculateRequirements(TaskDefinition taskDefinition) {
        log.debug((Object)"AbstractDeployitConfigurator.calculateRequirements");
        String executableLabel = (String)taskDefinition.getConfiguration().get("selectedExecutable");
        RequirementImpl executableReq = new RequirementImpl("system.builder.myExecutable." + executableLabel, true, ".*");
        String jdkLabel = (String)taskDefinition.getConfiguration().get("buildJdk");
        RequirementImpl jdkReq = new RequirementImpl("system.builder.jdk." + jdkLabel, true, ".*");
        return CollectionUtils.immutableSet(executableReq, jdkReq);
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        log.debug((Object)"AbstractDeployitConfigurator.validate");
        log.debug((Object)("params " + params));
        super.validate(params, errorCollection);
        String deployitUrl = params.getString(DEPLOYIT_URL);
        try {
            URL uRL = new URL(deployitUrl);
        }
        catch (MalformedURLException e) {
            errorCollection.addError(DEPLOYIT_URL, this.textProvider.getText("deployit.url.error"));
        }
        this.validateAttribute(params, errorCollection, DEPLOYIT_URL, "deployit.url.error");
        this.validateAttribute(params, errorCollection, DEPLOYIT_USERNAME, "deployit.username.error");
        this.validateAttribute(params, errorCollection, DEPLOYIT_PASSWORD, "deployit.password.error");
    }

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        log.debug((Object)"AbstractDeployitConfigurator.generateTaskConfigMap");
        HashMap<String, String> config = new HashMap<String, String>();
        this.bambooTaskConfigurationHelper.populateTaskConfigMapWithActionParameters(config, this.getParamsWithEncryptedPassword(params), CollectionUtils.concatIterables(FIELDS_TO_COPY, this.getExtraFieldsToCopy()));
        log.debug((Object)("AbstractDeployitConfigurator.generateTaskConfigMap config " + config));
        return config;
    }

    private ActionParametersMap getParamsWithEncryptedPassword(ActionParametersMap params) {
        String[] passwordArray = params.getStringArray(DEPLOYIT_PASSWORD);
        if (passwordArray != null && passwordArray.length > 0 && !AES_PASSWORD_ENCRYPTER.isEncrypted(passwordArray[0]) && !passwordArray[0].startsWith("${bamboo")) {
            Map originalParams = params.getParameters();
            String encryptedPassword = AES_PASSWORD_ENCRYPTER.doEncrypt(passwordArray[0]);
            originalParams.put(DEPLOYIT_PASSWORD, encryptedPassword);
            HttpParameters httpParameters = HttpParameters.create((Map)originalParams).build();
            return new SimpleActionParametersMap(httpParameters);
        }
        return params;
    }

    private void populateContextForAllOperations(Map<String, Object> context) {
        context.put(CTX_UI_CONFIG_SUPPORT, this.uiConfigSupport);
    }

    protected void validateAttribute(ActionParametersMap params, ErrorCollection errorCollection, String attribute, String errorKey) {
        if (StringUtils.isEmpty((String)params.getString(attribute))) {
            errorCollection.addError(attribute, this.textProvider.getText(errorKey));
        }
    }

    public void setTextProvider(TextProvider textProvider) {
        log.debug((Object)"DeployUpgradeConfigurator.setTextProvider");
        this.textProvider = textProvider;
    }

    protected Set<String> getExtraFieldsToCopy() {
        return Collections.emptySet();
    }

    public void setUiConfigBean(UIConfigSupport uiConfigSupport) {
        this.uiConfigSupport = uiConfigSupport;
    }
}

