/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.tasks;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.utils.FileVisitor;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.ci.bamboo.client.CiImport;
import com.xebialabs.deployit.ci.bamboo.client.ClientListener;
import com.xebialabs.deployit.ci.bamboo.client.ImportOptions;
import com.xebialabs.deployit.ci.bamboo.tasks.AbstractDeployitTask;
import java.io.File;
import java.util.HashSet;

public class ImportApplicationTaskAbstract
extends AbstractDeployitTask
implements ClientListener {
    private BuildLogger buildLogger;

    @Override
    void doExecute(CommonTaskContext taskContext, DeployitCommunicator communicator) {
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        this.buildLogger = taskContext.getBuildLogger();
        String pattern = (String)configurationMap.get((Object)"deployitDarPattern");
        String workDirConfig = (String)configurationMap.get((Object)"deployitDarWorkDir");
        File workDir = Strings.isNullOrEmpty((String)workDirConfig) ? taskContext.getWorkingDirectory() : new File(workDirConfig);
        File darfile = this.getDarFile(pattern, workDir);
        ImportOptions importOptions = new ImportOptions(darfile);
        CiImport deploy = new CiImport(communicator);
        deploy.importDar(importOptions);
    }

    private File getDarFile(String pattern, File workDir) {
        final HashSet darfiles = Sets.newHashSet();
        FileVisitor visitor = new FileVisitor(workDir){

            public void visitFile(File file) throws InterruptedException {
                darfiles.add(file);
            }
        };
        try {
            visitor.visitFilesThatMatch(pattern);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (darfiles.size() > 1) {
            throw new RuntimeException(String.format("Multiple DAR files with pattern %s found in %s", pattern, workDir));
        }
        if (darfiles.size() < 1) {
            throw new RuntimeException(String.format("No DAR files with pattern %s found in %s", pattern, workDir));
        }
        return (File)darfiles.iterator().next();
    }

    @Override
    public void info(String message) {
        this.buildLogger.addBuildLogEntry("[XL DEPLOY] " + message);
    }

    @Override
    public void error(String message) {
        this.buildLogger.addErrorLogEntry("[XL DEPLOY] " + message);
    }
}

