/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.xebialabs.deployit.ci.bamboo.configuration.AbstractDeployitConfigurator;
import com.xebialabs.deployit.ci.bamboo.util.CollectionUtils;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImportAppConfigurator
extends AbstractDeployitConfigurator {
    private static final Logger log = Logger.getLogger(ImportAppConfigurator.class);
    public static final String DEPLOYIT_DAR_PATTERN = "deployitDarPattern";
    public static final String DEPLOYIT_DAR_WORKDIR = "deployitDarWorkDir";
    private static final Set<String> FIELDS_TO_COPY = CollectionUtils.immutableSet("deployitDarPattern", "deployitDarWorkDir");

    @Override
    protected Set<String> getExtraFieldsToCopy() {
        return FIELDS_TO_COPY;
    }

    @Override
    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(DEPLOYIT_DAR_PATTERN, "**/*.dar");
    }

    @Override
    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        log.debug((Object)"ImportAppConfigurator.validate");
        log.debug((Object)("params " + params));
        super.validate(params, errorCollection);
        if (StringUtils.isBlank((String)params.getString(DEPLOYIT_DAR_PATTERN))) {
            errorCollection.addError(DEPLOYIT_DAR_PATTERN, this.textProvider.getText("deployit.import.error"));
        }
    }
}

