/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.bamboo.client;

import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.client.DeployitRemoteClient;
import com.xebialabs.deployit.ci.bamboo.client.ClientListener;
import com.xebialabs.deployit.ci.bamboo.client.DeployOptions;
import com.xebialabs.deployit.ci.bamboo.client.DeployitException;
import com.xebialabs.deployit.ci.bamboo.util.CollectionUtils;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.List;

public class CiDeploy {
    private final DeployitCommunicator communicator;
    private final DeployitRemoteClient client;
    private final TaskService taskService;
    private final RepositoryService repositoryService;
    private final DeploymentService deploymentService;
    private ClientListener listener;
    private int lastStep = 1;

    public CiDeploy(DeployitCommunicator communicator) {
        this(communicator, null);
    }

    public CiDeploy(DeployitCommunicator communicator, ClientListener listener) {
        this.communicator = communicator;
        this.client = new DeployitRemoteClient(communicator);
        this.listener = listener;
        this.deploymentService = communicator.getProxies().getDeploymentService();
        this.repositoryService = communicator.getProxies().getRepositoryService();
        this.taskService = communicator.getProxies().getTaskService();
    }

    public void deploy(DeployOptions options) {
        String deployedApplicationId = this.getDeployedApplicationId(options.getPackageId(), options.getEnvironmentId());
        boolean isDeployed = this.repositoryService.exists(deployedApplicationId);
        this.info(String.format("Starting deployment", new Object[0]));
        if (isDeployed) {
            this.info(String.format("Application %s is already deployed, doing an upgrade", deployedApplicationId));
            this.doUpgrade(options, deployedApplicationId);
        } else {
            this.info(String.format("Application %s is not yet deployed, doing an initial deployment", deployedApplicationId));
            this.doInitial(options);
        }
    }

    private void doUpgrade(DeployOptions options, String deployedApplicationId) {
        Deployment deployment = this.deploymentService.prepareUpdate(options.getPackageId(), deployedApplicationId);
        deployment.getDeployedApplication().setProperty("orchestrator", this.getOrchestrators(options));
        if (options.isUpdateDeployeds()) {
            deployment = this.deploymentService.prepareAutoDeployeds(deployment);
        }
        deployment = this.validateDeployment(deployment);
        this.info(String.format("Upgrading %s with options %s", deployedApplicationId, options));
        this.runDeployment(options, deployment);
    }

    private void doInitial(DeployOptions options) {
        Deployment deployment = this.deploymentService.prepareInitial(options.getPackageId(), options.getEnvironmentId());
        deployment.getDeployedApplication().setProperty("orchestrator", this.getOrchestrators(options));
        deployment = this.deploymentService.prepareAutoDeployeds(deployment);
        deployment = this.validateDeployment(deployment);
        this.info(String.format("Deploying with options %s", options));
        this.runDeployment(options, deployment);
    }

    private List<String> getOrchestrators(DeployOptions options) {
        String orchestrator = options.getOrchestrator();
        if (orchestrator == null || orchestrator.isEmpty()) {
            return null;
        }
        return CollectionUtils.splitAndTrimToList(orchestrator, ",");
    }

    private void runDeployment(DeployOptions options, Deployment deployment) {
        String task = this.deploymentService.createTask(deployment);
        TaskState taskState = this.startTaskAndWait(task);
        if (taskState.getState() == TaskExecutionState.EXECUTED) {
            this.info("Deployment successful. Archiving task.");
            this.taskService.archive(task);
        } else {
            if (options.getOnFailure().equals((Object)DeployOptions.FailAction.Rollback)) {
                String rollback = this.deploymentService.rollback(task);
                TaskState rollbackState = this.startTaskAndWait(rollback);
                if (rollbackState.getState() == TaskExecutionState.EXECUTED) {
                    this.taskService.archive(rollback);
                    throw new DeployitException("Deployment failed. Deployment rolled back successfully.");
                }
                this.taskService.cancel(rollback);
                throw new DeployitException("Deployment failed and rollback failed. Canceled rollback.");
            }
            if (options.getOnFailure().equals((Object)DeployOptions.FailAction.Cancel)) {
                this.taskService.cancel(task);
                throw new DeployitException("Deployment failed. Canceling task.");
            }
            if (options.getOnFailure().equals((Object)DeployOptions.FailAction.Nothing)) {
                throw new DeployitException("Deployment failed. Doing nothing.");
            }
        }
    }

    private TaskState startTaskAndWait(String task) {
        TaskState taskState;
        this.taskService.start(task);
        while (true) {
            taskState = this.taskService.getTask(task);
            this.printDoneSteps(taskState);
            if (taskState.getState().isPassiveAfterExecuting()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.printStep(this.taskService.getStep(task, taskState.getCurrentStepNr(), null));
        this.printDoneSteps(taskState);
        return taskState;
    }

    private void printDoneSteps(TaskState state) {
        int currentStep = state.getCurrentStepNr();
        for (int i = this.lastStep; i < currentStep; ++i) {
            StepState step = this.taskService.getStep(state.getId(), i, null);
            this.printStep(step);
            this.lastStep = currentStep;
        }
    }

    private void printStep(StepState step) {
        this.info("### " + step.getDescription() + " ###");
        this.info(step.getLog());
        StepExecutionState stepState = step.getState();
        if (stepState.equals((Object)StepExecutionState.FAILED)) {
            this.error("*** Step " + stepState.toString() + " ***");
        } else {
            this.info("*** Step " + stepState.toString() + " ***");
        }
    }

    private Deployment validateDeployment(Deployment deployment) {
        deployment = this.deploymentService.validate(deployment);
        ArrayList<ConfigurationItem> validatedDeployeds = new ArrayList<ConfigurationItem>(deployment.getDeployeds());
        validatedDeployeds.add(deployment.getDeployedApplication());
        boolean hasValidationErrors = false;
        for (ConfigurationItem validatedDeployed : validatedDeployeds) {
            if (!(validatedDeployed instanceof ValidatedConfigurationItem)) continue;
            List validations = ((ValidatedConfigurationItem)validatedDeployed).getValidations();
            for (ValidationMessage validation : validations) {
                hasValidationErrors = true;
                this.error(String.format("Deployment validation error found: %s ", validation));
            }
        }
        if (hasValidationErrors) {
            throw new DeployitException("Validation errors exist in deployment, automatic mapping not possible. Please correct mappings manually.");
        }
        this.info("Deployment validated.");
        return deployment;
    }

    public String getDeployedApplicationId(String application, String environment) {
        List<String> splitSource = CollectionUtils.splitAndTrimToList(application, "/");
        if (splitSource.size() <= 2) {
            throw new IllegalArgumentException("Application should be valid and include version.");
        }
        String appName = splitSource.get(splitSource.size() - 2);
        return CollectionUtils.trimAndJoin("/", environment, appName);
    }

    private void info(String msg) {
        if (this.listener != null) {
            this.listener.info(msg);
        }
    }

    private void error(String msg) {
        if (this.listener != null) {
            this.listener.error(msg);
        }
    }
}

