/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyDescriptorDto;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PrintHelper {
    public static void printCi(RepositoryObject object, Proxies proxies) {
        PrintHelper.printTopLevelCiWithIndent(object, "", proxies);
    }

    private static void printTopLevelCiWithIndent(RepositoryObject object, String indent, Proxies proxies) {
        System.out.println(object.getConfigurationItemTypeName());
        PrintHelper.printCiProperties(object, indent, proxies);
    }

    private static void printCiProperties(RepositoryObject object, String indent, Proxies proxies) {
        PrintHelper.println(indent, "id", object.getId(), false);
        PrintHelper.printCalendar(indent, "lastModified", object.getLastModified(), false);
        PrintHelper.println(indent, "values", null, true);
        Map<String, ConfigurationItemPropertyDescriptorDto> pds = PrintHelper.getPropertyDescriptors(object, proxies);
        indent = indent + "    ";
        PrintHelper.printValues(object, indent, proxies, pds);
    }

    private static void printValues(RepositoryObject object, String indent, Proxies proxies, Map<String, ConfigurationItemPropertyDescriptorDto> pds) {
        Set entries = object.getValues().entrySet();
        Iterator entryIt = entries.iterator();
        block7: while (entryIt.hasNext()) {
            Map.Entry entry = entryIt.next();
            ConfigurationItemPropertyDescriptorDto dto = pds.get(entry.getKey());
            boolean last = !entryIt.hasNext();
            String deepIndent = indent + (entryIt.hasNext() ? "|   " : "    ");
            if (dto == null) {
                PrintHelper.println(indent, "(INVALID) " + (String)entry.getKey(), entry.getValue().toString(), last);
                continue;
            }
            switch (dto.getType()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    PrintHelper.println(indent, (String)entry.getKey(), entry.getValue().toString(), last);
                    break;
                }
                case SET_OF_STRINGS: {
                    PrintHelper.println(indent, (String)entry.getKey(), null, last);
                    Collection strings = (Collection)entry.getValue();
                    Iterator stringIt = strings.iterator();
                    while (stringIt.hasNext()) {
                        String string = (String)stringIt.next();
                        PrintHelper.println(deepIndent, string, null, !stringIt.hasNext());
                    }
                    continue block7;
                }
                case LIST_OF_OBJECTS: {
                    PrintHelper.println(indent, (String)entry.getKey(), null, last);
                    PrintHelper.printListObjects(deepIndent, (Collection)entry.getValue(), dto);
                    break;
                }
                case CI: {
                    String id = (String)entry.getValue();
                    RepositoryObject nested = (RepositoryObject)new ResponseExtractor(proxies.getRepository().read(id)).getEntity();
                    PrintHelper.println(indent, (String)entry.getKey(), nested.getConfigurationItemTypeName(), last);
                    PrintHelper.printCiProperties(nested, deepIndent, proxies);
                    break;
                }
                case SET_OF_CIS: {
                    PrintHelper.println(indent, (String)entry.getKey(), null, last);
                    Collection ids = (Collection)entry.getValue();
                    PrintHelper.printSetOfCis(deepIndent, ids, proxies);
                    break;
                }
            }
        }
    }

    private static void printSetOfCis(String indent, Collection<String> ids, Proxies proxies) {
        Iterator<String> idIt = ids.iterator();
        while (idIt.hasNext()) {
            String nestedid = idIt.next();
            RepositoryObject nestedCi = (RepositoryObject)new ResponseExtractor(proxies.getRepository().read(nestedid)).getEntity();
            PrintHelper.println(indent, nestedCi.getConfigurationItemTypeName(), null, !idIt.hasNext());
            PrintHelper.printCiProperties(nestedCi, indent + (idIt.hasNext() ? "|   " : "    "), proxies);
        }
    }

    private static void printListObjects(String indent, Collection<?> objects, ConfigurationItemPropertyDescriptorDto dto) {
        Iterator<?> objectIt = objects.iterator();
        while (objectIt.hasNext()) {
            Map object = (Map)objectIt.next();
            PrintHelper.println(indent, dto.getCollectionMemberClassname(), null, !objectIt.hasNext());
            Iterator objEntryIt = object.entrySet().iterator();
            while (objEntryIt.hasNext()) {
                Map.Entry entry = objEntryIt.next();
                PrintHelper.println(indent + (objectIt.hasNext() ? "|   " : "    "), (String)entry.getKey(), (String)entry.getValue(), !objEntryIt.hasNext());
            }
        }
    }

    private static Map<String, ConfigurationItemPropertyDescriptorDto> getPropertyDescriptors(RepositoryObject object, Proxies proxies) {
        ConfigurationItemDescriptorDto descriptor = (ConfigurationItemDescriptorDto)new ResponseExtractor(proxies.getDescriptors().find(object.getConfigurationItemTypeName())).getEntity();
        List propertyDescriptors = descriptor.getPropertyDescriptors();
        HashMap pds = Maps.newHashMap();
        for (ConfigurationItemPropertyDescriptorDto propertyDescriptor : propertyDescriptors) {
            pds.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return pds;
    }

    private static void println(String indent, String key, String value, boolean last) {
        System.out.println(indent + (last ? "\\-- " : "+-- ") + key + (value != null ? ": " + value : ""));
    }

    private static void printCalendar(String indent, String key, Calendar value, boolean last) {
        if (value != null) {
            PrintHelper.println(indent, key, new SimpleDateFormat("yyyy-MM-dd hh:MM:ss.SSS").format(value.getTime()), last);
        } else {
            PrintHelper.println(indent, key, null, last);
        }
    }
}

