package com.xebialabs.deployit.cli.help;

import com.xebialabs.deployit.cli.CliObject;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

import static java.lang.System.out;

public class HelpScanner {

	private static final AtomicReference<Set<Class<?>>> discoveredCliObjects = new AtomicReference<Set<Class<?>>>();

    public static void printHelp(Set<Class<?>> clazzes) {
	    discoveredCliObjects.set(clazzes);
	    printHelp();
    }
	public static void printHelp() {
        out.println("Deployit Objects available on the CLI");
        out.println("To know more about a specific object, type <objectname>.help()");
        out.println("To get to know more about a specific method of an object, type <objectname>.help(\"<methodname>\")");
        out.println();
        for (Class<?> clazz : discoveredCliObjects.get()) {
            final ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
            final CliObject cliObject = clazz.getAnnotation(CliObject.class);
            if (classHelp != null) {
                out.printf("%s: %s\n", cliObject.name(), classHelp.description());
            }
        }
    }

    public static void printHelp(Class<?> clazz) {
        final ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
        final CliObject cliObject = clazz.getAnnotation(CliObject.class);
        if (classHelp != null) {
            final String objectName = cliObject.name();
            out.printf("%s: %s\n\n", objectName, classHelp.description());
            printMethods(objectName, clazz);
            out.println();
        } else {
            out.println("Not found help for " + clazz);
        }
    }

    public static void printHelp(Class<?> clazz, String methodName) throws NoSuchMethodException {
        final ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
        final CliObject cliObject = clazz.getAnnotation(CliObject.class);
        if (classHelp != null) {
            final String objectName = cliObject.name();
            for (Method method : clazz.getMethods()) {
                if (method.getName().equals(methodName)) {
                    printMethod(objectName, method);
                    printMethodDetails(method);
                    out.println();
                }
            }
        }
    }

    private static void printMethodDetails(final Method method) {
        final MethodHelp methodHelp = method.getAnnotation(MethodHelp.class);
        if (methodHelp != null) {
            out.println(methodHelp.description());
            out.printf("Returns: %s - %s\n", method.getReturnType().getSimpleName(), methodHelp.returns());
            out.println();
            for (ParameterHelp parameterHelp : methodHelp.parameters()) {
                out.printf("%s: %s\n", parameterHelp.name(), parameterHelp.description());
            }
        }
    }

    private static void printMethods(String objectName, final Class<?> clazz) {
        out.println("The methods available are:");
        for (Method method : clazz.getDeclaredMethods()) {
            printMethod(objectName, method);
        }
    }

    private static void printMethod(final String objectName, final Method method) {
        final MethodHelp methodHelp = method.getAnnotation(MethodHelp.class);
        if (methodHelp != null) {
            String methodName = method.getName();
            StringBuilder params = new StringBuilder();
            final Class<?>[] classes = method.getParameterTypes();
            final ParameterHelp[] parameterHelps = methodHelp.parameters();
            if (classes.length != parameterHelps.length) {
                throw new IllegalArgumentException("Not all parameters are documented!");
            }

            for (int i = 0; i < classes.length; i++) {
                params.append(classes[i].getSimpleName());
                params.append(" ").append(parameterHelps[i].name());
                if (i < classes.length - 1) {
                    params.append(", ");
                }
            }
            out.printf("%s.%s(%s) : %s\n", objectName, methodName, params, method.getReturnType().getSimpleName());
        }
    }

}
