/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.ScriptEngineBuilder;
import com.xebialabs.deployit.cli.help.HelpScanner;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import jline.ConsoleReader;
import jline.Terminal;

public class Interpreter {
    private ScriptEngine scriptEngine;
    private ScriptContext scriptContext;
    private ConsoleReader consoleReader;
    private CliOptions options;

    public Interpreter(ConsoleReader consoleReader, ScriptEngineBuilder scriptEngineBuilder, CliOptions options) {
        this.consoleReader = consoleReader;
        this.scriptEngine = scriptEngineBuilder.build(options);
        this.options = options;
        this.scriptContext = new SimpleScriptContext();
    }

    void interpret() {
        block6: {
            try {
                if (this.options.interpretSourceFile()) {
                    this.evaluate(new FileReader(this.options.getSourceFileName()));
                    break block6;
                }
                try {
                    this.advancedRepl(this.consoleReader);
                }
                catch (IOException e) {
                    throw new IllegalStateException("The REPL gave an exception!", e);
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("File " + this.options.getSourceFileName() + " could not be read, reason:" + e.getMessage());
                System.exit(1);
            }
            catch (ScriptException e) {
                System.err.println("An error occurred while interpreting file " + this.options.getSourceFileName() + ", reason:" + e.getMessage());
                System.exit(1);
            }
        }
    }

    public Object evaluate(Reader reader) throws ScriptException {
        return this.scriptEngine.eval(reader, this.scriptContext);
    }

    Object evaluate(String expression) throws ScriptException {
        if (expression == null) {
            return null;
        }
        return this.scriptEngine.eval(expression, this.scriptContext);
    }

    private void advancedRepl(ConsoleReader consoleReader) throws IOException {
        while (true) {
            String line;
            String trimmed;
            String string = trimmed = (line = consoleReader.readLine(this.getPrompt())) != null ? line.trim() : line;
            if (trimmed == null || trimmed.startsWith("quit") || line.trim().startsWith("exit")) break;
            if (trimmed.startsWith("help")) {
                HelpScanner.printHelp();
                continue;
            }
            try {
                this.evaluate(line);
            }
            catch (ScriptException e) {
                System.err.println("Exception: " + e);
            }
        }
        this.exit();
    }

    protected void exit() {
        System.out.println("Bye bye!");
        Terminal.resetTerminal();
    }

    String getPrompt() {
        return "deployit > ";
    }
}

