package com.xebialabs.deployit.cli.api.legacy;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;

/**
 * Translates the new {@link TaskWithSteps} object to the legacy Deployit 3.7 {@code FullTaskInfo} API.
 *
 * @ deprecated Use {@link TaskWithSteps}.
 */
//@Deprecated
public class FullTaskInfo extends TaskInfo {

    private List<StepInfo> stepInfoList;

    public FullTaskInfo(TaskWithSteps task) {
        super(task);
        this.stepInfoList = StepInfo.asList(task.getSteps());
    }

    public static List<FullTaskInfo> asFullList(List<TaskWithSteps> tasks) {
        List<FullTaskInfo> result = new ArrayList<FullTaskInfo>(tasks.size());
        for (TaskWithSteps task : tasks) {
            result.add(new FullTaskInfo(task));
        }
        return result;
    }

    public List<StepInfo> getSteps() {
        return stepInfoList;
    }

    public boolean hasSteps() {
        return (this.stepInfoList != null) && !this.stepInfoList.isEmpty();
    }
}
