package com.xebialabs.deployit.cli.api.legacy;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import com.xebialabs.deployit.engine.api.execution.TaskState;

/**
 * Translates the new {@link TaskState} object to the legacy Deployit 3.7 {@code TaskInfo} API.
 *
 * @ deprecated Use {@link TaskState}.
 */
//@Deprecated
public class TaskInfo {

    private final TaskState task;

    public TaskInfo(TaskState task) {
        this.task = task;
    }

    public static List<TaskInfo> asList(List<TaskState> tasks) {
        List<TaskInfo> result = new ArrayList<TaskInfo>(tasks.size());
        for (TaskState task : tasks) {
            result.add(new TaskInfo(task));
        }
        return result;
    }

    public TaskState getTaskState() {
        return task;
    }

    public String getId() {
        return task.getId();
    }

    public String getLabel() {
        return task.getDescription();
    }

    public String getState() {
        return task.getState().toString();
    }

    public Calendar getStartDate() {
        return task.getStartDate().toGregorianCalendar();
    }

    public Calendar getCompletionDate() {
        return task.getCompletionDate().toGregorianCalendar();
    }

    public int getNrOfSteps() {
        return task.getNrSteps();
    }

    public int getCurrentStepNr() {
        return task.getCurrentStepNr();
    }

    public String getUser() {
        throw new IllegalStateException("Can't get the user from the task.");
    }

    public String getApplication() {
        return task.getMetadata().get("application");
    }

    public String getVersion() {
        return task.getMetadata().get("version");
    }

    public String getEnvironment() {
        return task.getMetadata().get("environment");
    }

    public int getFailureCount() {
        return task.getFailureCount();
    }

    @Override
    public String toString() {
        return String.format("Task %s (%s)", task.getId(), task.getState());
    }
}
