package com.xebialabs.deployit.cli.help;

import java.io.*;

import javax.imageio.spi.ImageOutputStreamSpi;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;

import com.xebialabs.deployit.booter.remote.HttpClientHolder;

import static java.lang.String.format;

public class ExportHelp {

    private ExportHelp() {
    }

    public static long writeResourceToLocalFile(final String filePath, final String resourceURL) throws IOException {
        FileOutputStream outputResourceFile = null;
        HttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet("/" + resourceURL);
            response = HttpClientHolder.httpClient().execute(HttpClientHolder.getInstance().getHost(), httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                outputResourceFile = new FileOutputStream(filePath);
                InputStream content = response.getEntity().getContent();
                try {
                    ByteStreams.copy(content, outputResourceFile);
                } finally {
                    Closeables.closeQuietly(content);
                }
                return 1;
            } else if (statusCode == 401 || statusCode == 403) {
                throw new IllegalStateException("You were not authenticated correctly, did you use the correct credentials?");
            } else {
                throw new IllegalStateException("Could contact the deployit server, but received an HTTP error code, " + statusCode);
            }
        } catch (IOException outputFileException) {
            throw new IOException(format("The file at %s could not be created.", filePath));
        } finally {
            if (response != null) {
                EntityUtils.consume(response.getEntity());
            }
            Closeables.closeQuietly(outputResourceFile);
        }
    }
}
