/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.booter.remote.HttpClientHolder;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitClientException;
import com.xebialabs.deployit.engine.api.dto.FileUpload;
import com.xebialabs.deployit.engine.xml.XStreamReaderWriter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportHelper {
    private static final Logger logger = LoggerFactory.getLogger(ImportHelper.class);

    public ConfigurationItem doImport(String baseUri, String packageToImport) {
        try {
            URL url = new URL(packageToImport);
            if (url.getProtocol().equals("file")) {
                return this.processFilePath(baseUri, url.getFile());
            }
            HttpPost httpPost = new HttpPost(baseUri + "/package/fetch");
            httpPost.setEntity((HttpEntity)new StringEntity(url.toString(), ContentType.create((String)"application/xml", (String)"UTF-8")));
            return this.executeAndExtract(httpPost);
        }
        catch (MalformedURLException e) {
            return this.processFilePath(baseUri, packageToImport);
        }
        catch (UnsupportedCharsetException e) {
            throw new RuntimeException(e);
        }
    }

    private ConfigurationItem executeAndExtract(HttpPost httpPost) {
        HttpResponse execute = null;
        try {
            HttpClientHolder instance = HttpClientHolder.getInstance();
            HttpClient httpClient = HttpClientHolder.httpClient();
            execute = httpClient.execute(instance.getHost(), (HttpRequest)httpPost);
            int i = execute.getStatusLine().getStatusCode();
            if (i < 300) {
                ConfigurationItem configurationItem = this.extract(execute);
                return configurationItem;
            }
            try {
                throw new DeployitClientException("Error! (" + i + ")", i);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (execute != null) {
                try {
                    EntityUtils.consume((HttpEntity)execute.getEntity());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected ConfigurationItem extract(HttpResponse postMethod) throws IOException {
        return (ConfigurationItem)XStreamReaderWriter.getConfiguredXStream().fromXML(postMethod.getEntity().getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationItem processFilePath(String baseUri, String path) {
        File file = new File(path);
        if (file.exists()) {
            ConfigurationItem configurationItem;
            FileUpload fileUpload = new FileUpload();
            FileInputStream fileData = null;
            try {
                fileData = new FileInputStream(file);
                fileUpload.setFileData((InputStream)fileData);
                HttpPost httpPost = new HttpPost(baseUri + "/package/upload/" + file.getName());
                MultipartEntity entity = new MultipartEntity();
                entity.addPart("fileData", (ContentBody)new FileBody(file));
                httpPost.setEntity((HttpEntity)entity);
                configurationItem = this.executeAndExtract(httpPost);
            }
            catch (IOException e) {
                ConfigurationItem configurationItem2;
                try {
                    logger.error("The file '{}' exists, but could not be read for upload; perhaps it's not an archive.", (Object)file.toString());
                    configurationItem2 = null;
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(fileData);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)fileData);
                return configurationItem2;
            }
            Closeables.closeQuietly((Closeable)fileData);
            return configurationItem;
        }
        if (!file.isAbsolute()) {
            HttpPost postMethod = new HttpPost(baseUri + "/package/import/" + path);
            return this.executeAndExtract(postMethod);
        }
        logger.error("The file '{}' does not exist at the given absolute path", (Object)file.toString());
        return null;
    }
}

