/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static String readFile(String file) throws IOException {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(Paths.get(file, new String[0])));
        }
        catch (IOException exc) {
            throw new IOException(String.format("The file path %s could not be found.", file));
        }
    }

    public static String readFile(File file) throws IOException {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(file.toPath()));
        }
        catch (IOException exc) {
            throw new IOException(String.format("The file path %s could not be found.", file));
        }
    }

    public static List<File> readFiles(List<String> fileNames, String path) throws IOException {
        File folder = new File(path);
        ArrayList<File> files = new ArrayList<File>();
        for (String file : fileNames) {
            File e = FileUtils.getFile(folder, file);
            files.add(e);
        }
        return files;
    }

    private static File getFile(File folder, String file) throws IOException {
        Path filePath = Paths.get(file, new String[0]);
        if (filePath.isAbsolute()) {
            return FileUtils.checkNonExistingPath(filePath.toFile());
        }
        Path pathIncludingFolder = Paths.get(folder.getPath(), file);
        return FileUtils.checkNonExistingPath(pathIncludingFolder.toFile());
    }

    private static File checkNonExistingPath(File file) throws IOException {
        if (file.exists()) {
            return file;
        }
        throw new IOException(String.format("%s could not be found in %s", file.getName(), file.getParent()));
    }

    public static void writeFile(String content, File file) throws IOException {
        Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

