/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.core.api.dto.ResolvedPlaceholderView;
import java.util.List;

@CliObject(name="placeholder")
@ClassHelp(description="Access to the resolved placeholders from the dictionaries.")
public class PlaceholderClient
extends DocumentedObject {
    private ProxiesInstance proxies;

    public PlaceholderClient() {
    }

    public PlaceholderClient(ProxiesInstance proxies) {
        this.proxies = proxies;
    }

    @MethodHelp(description="Lists all resolved placeholder for specified infrastructure ci.", parameters={@ParameterHelp(name="infrastructureId", description="The id of the infrastructure.")})
    public List<ResolvedPlaceholderView> infrastructure(String infrastructureId) {
        return this.proxies.getPlaceholderService().findPlaceholdersForHost(infrastructureId, null, null, null, null, null, null, null);
    }

    @MethodHelp(description="Lists all resolved placeholder for specified infrastructure ci.", parameters={@ParameterHelp(name="environmentId", description="The id of the environment.")})
    public List<ResolvedPlaceholderView> environment(String environmentId) {
        return this.proxies.getPlaceholderService().findPlaceholdersForEnvironment(environmentId, null, null, null, null, null, null, null);
    }
}

