/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.ext.plainarchive.config.ConfigParser;
import com.xebialabs.deployit.cli.ext.plainarchive.config.RuleParser;
import com.xebialabs.deployit.cli.ext.plainarchive.dar.DarManifestBuilder;
import com.xebialabs.deployit.cli.ext.plainarchive.dar.DarWriter;
import com.xebialabs.deployit.cli.ext.plainarchive.io.Filenames;
import com.xebialabs.deployit.cli.ext.plainarchive.io.Files2;
import com.xebialabs.deployit.cli.ext.plainarchive.io.TFiles;
import com.xebialabs.deployit.cli.ext.plainarchive.matcher.CarMatcher;
import com.xebialabs.deployit.cli.ext.plainarchive.matcher.ConfigurationItemMatcher;
import com.xebialabs.deployit.cli.ext.plainarchive.matcher.PathMatcher;
import com.xebialabs.deployit.cli.ext.plainarchive.matcher.RegexMatcher;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CliObject(name="zipconverter")
public class PlainArchiveConverter {
    @VisibleForTesting
    static final String DEFAULT_APP_VERSION = "1.0";
    private static final String DAR_SUFFIX = ".dar";
    private static final Logger LOGGER = LoggerFactory.getLogger(PlainArchiveConverter.class);
    private static final String CONFIG_FILE_NAME = "plain-archive-converter.properties";
    private static final Properties CONFIG = new Properties();
    private static final Collection<ConfigurationItemMatcher.MatcherFactory> MATCHER_FACTORIES = ImmutableSet.of((Object)new PathMatcher.PathMatcherFactory(), (Object)new RegexMatcher.RegexMatcherFactory(), (Object)new CarMatcher.CarMatcherFactory());
    private final List<ConfigurationItemMatcher> matchers;

    public PlainArchiveConverter(Proxies ignored) {
        this((List<ConfigurationItemMatcher>)new ConfigParser(CONFIG, new RuleParser(MATCHER_FACTORIES)).get());
    }

    @VisibleForTesting
    protected PlainArchiveConverter(List<ConfigurationItemMatcher> matchers) {
        this.matchers = matchers;
    }

    public File convert(String sourcePath) throws IOException {
        Filenames.VersionedFilename sourceName = Filenames.VersionedFilename.from(FilenameUtils.getBaseName((String)sourcePath), DEFAULT_APP_VERSION);
        return this.convert(sourcePath, sourceName.name, sourceName.version);
    }

    public File convert(String sourcePath, String appName, String version) throws IOException {
        return this.convert(sourcePath, appName, version, Files2.getTempFilePath(FilenameUtils.getBaseName((String)sourcePath), FilenameUtils.getExtension((String)sourcePath)));
    }

    public File convert(String sourcePath, String targetPath) throws IOException {
        Filenames.VersionedFilename sourceName = Filenames.VersionedFilename.from(FilenameUtils.getBaseName((String)sourcePath), DEFAULT_APP_VERSION);
        return this.convert(sourcePath, sourceName.name, sourceName.version, targetPath);
    }

    public File convert(String sourcePath, String appName, String version, String targetPath) throws IOException {
        File target;
        if (!targetPath.endsWith(DAR_SUFFIX)) {
            targetPath = targetPath + DAR_SUFFIX;
            LOGGER.info("Result file will be '{}' since DARs must end in '{}' to be importable", (Object)targetPath, (Object)DAR_SUFFIX);
        }
        Preconditions.checkArgument((!(target = new File(targetPath)).exists() ? 1 : 0) != 0, (String)"Target file '%s' already exists", (Object[])new Object[]{targetPath});
        return this.convert(sourcePath, appName, version, target);
    }

    private File convert(String sourcePath, String appName, String version, File target) throws IOException {
        TFile sourceArchive = new TFile(sourcePath);
        PlainArchiveConverter.checkValidArchive(sourceArchive);
        Iterable collectedEntries = Iterables.filter((Iterable)Iterables.transform(TFiles.listTFiles(sourceArchive), (Function)new Function<TFile, DarManifestBuilder.DarEntry>(){

            public DarManifestBuilder.DarEntry apply(TFile input) {
                for (ConfigurationItemMatcher matcher : PlainArchiveConverter.this.matchers) {
                    ConfigurationItemMatcher.MatchResult result = matcher.apply(input);
                    if (!result.matched) continue;
                    LOGGER.debug("Matched '{}' to DAR entry '{}'", (Object)input, (Object)result.result);
                    return result.result;
                }
                return DarManifestBuilder.DarEntry.NULL;
            }
        }), (Predicate)Predicates.not((Predicate)new Predicate<DarManifestBuilder.DarEntry>(){

            public boolean apply(DarManifestBuilder.DarEntry input) {
                return input == DarManifestBuilder.DarEntry.NULL;
            }
        }));
        Files.copy((File)sourceArchive, (File)target);
        LOGGER.debug("Copied source archive {} to new target {}", (Object)sourceArchive, (Object)target);
        LOGGER.info("Converting plain archive '{}' to DAR '{}' for '{}' version '{}'", new Object[]{sourceArchive, target, appName, version});
        LOGGER.debug("Adding manifest to new target {}", (Object)target);
        DarWriter.addManifest(target, new DarManifestBuilder().setApplication(appName).setVersion(version).addDarEntries(collectedEntries).build());
        DarWriter.flush(target);
        return target;
    }

    private static void checkValidArchive(TFile archive) {
        Preconditions.checkArgument((boolean)archive.exists(), (String)"Archive '%s' does not exist or cannot be read", (Object[])new Object[]{archive});
        Preconditions.checkArgument((boolean)archive.isArchive(), (String)"File '%s' is not a valid ZIP archive", (Object[])new Object[]{archive});
        Preconditions.checkArgument((!new TFile((File)archive, "META-INF/MANIFEST.MF").exists() ? 1 : 0) != 0, (String)"Archive '%s' already contains a manifest at '%s'", (Object[])new Object[]{archive, "META-INF/MANIFEST.MF"});
    }

    static {
        try {
            CONFIG.load((InputStream)Preconditions.checkNotNull((Object)Thread.currentThread().getContextClassLoader().getResourceAsStream(CONFIG_FILE_NAME), (Object)CONFIG_FILE_NAME));
        }
        catch (Exception exception) {
            LOGGER.warn(String.format("Unable to load configuration file '%s' from classpath", CONFIG_FILE_NAME), (Throwable)exception);
        }
    }
}

