/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.base;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class UriQueryStrings {
    private static final char ATTRIBUTES_SEPARATOR = '&';
    private static final String ATTRIBUTE_KEY_VALUE_SEPARATOR = Pattern.quote("=");

    @Nonnull
    public static Map<String, String> toMap(@Nonnull String queryString) {
        ImmutableMap.Builder inProgress = ImmutableMap.builder();
        for (String keyValue : Splitter.on((char)'&').split((CharSequence)queryString)) {
            String[] keyAndValue = keyValue.split(ATTRIBUTE_KEY_VALUE_SEPARATOR);
            Preconditions.checkArgument((keyAndValue.length == 2 ? 1 : 0) != 0, (String)"Invalid query string format. Expected 'key=value&key2=value&...' but found section '%s'", (Object[])new Object[]{keyValue});
            inProgress.put((Object)keyAndValue[0], (Object)keyAndValue[1]);
        }
        return inProgress.build();
    }
}

