/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.collect;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class Maps2 {
    @Nonnull
    public static <K, V> Map<K, V> fromKeys(@Nonnull Set<K> keys, @Nonnull Function<? super K, V> valueFunction) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)keys.size());
        for (K key : keys) {
            result.put(Preconditions.checkNotNull(key), valueFunction.apply(key));
        }
        return result;
    }

    @Nonnull
    public static <K1, K2, V> Map<K2, V> transformKeys(@Nonnull Map<K1, V> fromMap, Function<? super K1, K2> function) {
        ImmutableMap newKeys = Maps.uniqueIndex(fromMap.keySet(), function);
        return Maps.transformValues((Map)newKeys, (Function)Functions.forMap(fromMap));
    }

    @Nonnull
    public static <K, V> Map<V, Set<K>> reduce(@Nonnull Map<K, V> fromMap) {
        HashMap inProgress = Maps.newHashMap();
        for (Map.Entry entry : Maps.filterValues(fromMap, (Predicate)Predicates.notNull()).entrySet()) {
            Object value = entry.getValue();
            if (!inProgress.containsKey(value)) {
                inProgress.put(value, Sets.newHashSet());
            }
            ((Set)inProgress.get(value)).add(entry.getKey());
        }
        return ImmutableMap.copyOf((Map)inProgress);
    }
}

