/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.config;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.cli.ext.plainarchive.config.RuleParser;
import com.xebialabs.deployit.cli.ext.plainarchive.matcher.ConfigurationItemMatcher;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class ConfigParser
implements Supplier<List<ConfigurationItemMatcher>> {
    private static final int MIN_PROPERTIES_PER_RULE = 2;
    private final List<ConfigurationItemMatcher> matchers;

    public ConfigParser(@Nonnull Properties config, @Nonnull RuleParser ruleParser) {
        this.matchers = ConfigParser.parseRules(config, ruleParser);
    }

    private static List<ConfigurationItemMatcher> parseRules(Properties config, RuleParser parser) {
        Map<String, String> nthRuleProperties;
        LinkedList matchers = Lists.newLinkedList();
        ImmutableMap configProperties = Maps.fromProperties((Properties)config);
        int maxNumRules = config.size() / 2;
        for (int i = 1; i <= maxNumRules && !(nthRuleProperties = new RulePropertiesCollector(i).apply((Map<String, String>)configProperties)).isEmpty(); ++i) {
            matchers.add(parser.apply(nthRuleProperties));
        }
        return matchers;
    }

    @Nonnull
    public List<ConfigurationItemMatcher> get() {
        return this.matchers;
    }

    private static class KeyTransformer<K1, V, K2>
    implements Function<Map<K1, V>, Map<K2, V>> {
        private final Function<K1, K2> keyTransform;

        private KeyTransformer(Function<K1, K2> keyTransform) {
            this.keyTransform = keyTransform;
        }

        public Map<K2, V> apply(Map<K1, V> input) {
            ImmutableMap newKeys = Maps.uniqueIndex(input.keySet(), this.keyTransform);
            return Maps.transformValues((Map)newKeys, (Function)Functions.forMap(input));
        }
    }

    private static class RulePropertiesCollector
    implements Function<Map<String, String>, Map<String, String>> {
        private static final String RULE_PROPERTY_PREFIX = "rule.";
        private final String indexedRulePrefix;

        private RulePropertiesCollector(int ruleIndex) {
            this.indexedRulePrefix = RULE_PROPERTY_PREFIX + ruleIndex + '.';
        }

        public Map<String, String> apply(Map<String, String> from) {
            KeyTransformer prefixStripper = new KeyTransformer((Function)new Function<String, String>(){

                public String apply(String from) {
                    return StringUtils.substringAfter((String)from, (String)RulePropertiesCollector.this.indexedRulePrefix);
                }
            });
            return ImmutableMap.copyOf(prefixStripper.apply(Maps.filterKeys(from, (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return input.startsWith(RulePropertiesCollector.this.indexedRulePrefix);
                }
            })));
        }
    }
}

