/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.cli.ext.plainarchive.matcher.ConfigurationItemMatcher;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;

public class RuleParser
implements Function<Map<String, String>, ConfigurationItemMatcher> {
    private static final String TYPE_PROPERTY = "type";
    private final Map<String, ConfigurationItemMatcher.MatcherFactory> matcherFactories;

    public RuleParser(Collection<ConfigurationItemMatcher.MatcherFactory> matcherFactories) {
        this.matcherFactories = Maps.uniqueIndex(matcherFactories, (Function)new Function<ConfigurationItemMatcher.MatcherFactory, String>(){

            public String apply(ConfigurationItemMatcher.MatcherFactory input) {
                return input.getMatcherType();
            }
        });
    }

    @Nonnull
    public ConfigurationItemMatcher apply(@Nonnull Map<String, String> config) {
        String matcherType = config.get(TYPE_PROPERTY);
        Preconditions.checkArgument((matcherType != null ? 1 : 0) != 0, (String)"config property '%s' is required", (Object[])new Object[]{TYPE_PROPERTY});
        ConfigurationItemMatcher.MatcherFactory matcherFactory = this.matcherFactories.get(matcherType);
        Preconditions.checkArgument((matcherFactory != null ? 1 : 0) != 0, (String)"unknown rule type '%s'", (Object[])new Object[]{matcherType});
        return matcherFactory.from(config);
    }
}

