/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.dar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.cli.ext.plainarchive.collect.Maps2;
import com.xebialabs.deployit.cli.ext.plainarchive.dar.ManifestBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class DarManifestBuilder
extends ManifestBuilder {
    @VisibleForTesting
    public static final String APPLICATION_ATTRIBUTE_NAME = "Ci-Application";
    @VisibleForTesting
    public static final String VERSION_ATTRIBUTE_NAME = "Ci-Version";
    private static final String PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME = "Deployit-Package-Format-Version";
    private static final String PACKAGE_FORMAT_VERSION_NUMBER = "1.3";

    public DarManifestBuilder() {
        this.addMainAttribute(PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME, PACKAGE_FORMAT_VERSION_NUMBER);
    }

    public DarManifestBuilder setApplication(@Nonnull String applicationName) {
        this.addMainAttribute(APPLICATION_ATTRIBUTE_NAME, (String)Preconditions.checkNotNull((Object)applicationName, (Object)"applicationName"));
        return this;
    }

    public DarManifestBuilder setVersion(@Nonnull String version) {
        this.addMainAttribute(VERSION_ATTRIBUTE_NAME, (String)Preconditions.checkNotNull((Object)version, (Object)"version"));
        return this;
    }

    public DarManifestBuilder addDarEntry(@Nonnull DarEntry entry) {
        entry.addToManifest(this);
        return this;
    }

    public DarManifestBuilder addDarEntries(@Nonnull Iterable<DarEntry> entries) {
        for (DarEntry entry : entries) {
            this.addDarEntry(entry);
        }
        return this;
    }

    public static class DarEntry {
        public static final DarEntry NULL = new DarEntry("", (Map<String, String>)ImmutableMap.of(), "");
        private static final String CI_ATTRIBUTE_PREFIX = "Ci-";
        private static final String TYPE_ATTRIBUTE_NAME = "Ci-type";
        private final String type;
        private final Map<String, String> properties;
        private final String jarEntryPath;

        public DarEntry(@Nonnull String type, @Nonnull Map<String, String> properties, @Nonnull String jarEntryPath) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.properties = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(properties, (Object)"properties")));
            this.jarEntryPath = (String)Preconditions.checkNotNull((Object)jarEntryPath, (Object)"jarEntryPath");
        }

        private void addToManifest(@Nonnull ManifestBuilder builder) {
            HashMap attributes = Maps.newHashMapWithExpectedSize((int)(1 + this.properties.size()));
            attributes.put(TYPE_ATTRIBUTE_NAME, this.type);
            attributes.putAll(Maps2.transformKeys(this.properties, new Function<String, String>(){

                public String apply(String input) {
                    return DarEntry.CI_ATTRIBUTE_PREFIX + input;
                }
            }));
            builder.addEntryAttributes(this.jarEntryPath, attributes);
        }

        public String toString() {
            return "DarEntry [type=" + this.type + ", properties=" + this.properties + ", jarEntryPath=" + this.jarEntryPath + "]";
        }
    }
}

