/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.dar;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarWriter {
    public static final String DAR_EXTENSION = "dar";
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final Logger LOGGER = LoggerFactory.getLogger(DarWriter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addManifest(@Nonnull File dar, @Nonnull Manifest manifest) throws IOException {
        TFile manifestFile = new TFile(dar, MANIFEST_PATH);
        Preconditions.checkArgument((!manifestFile.exists() ? 1 : 0) != 0, (String)"DAR '%s' already contains a manifest at '%s'", (Object[])new Object[]{dar, MANIFEST_PATH});
        TFileOutputStream out = new TFileOutputStream((File)manifestFile);
        try {
            LOGGER.debug("Opened output stream to write manifest '{}' to '{}'", (Object)MANIFEST_PATH, (Object)dar);
            manifest.write((OutputStream)out);
            LOGGER.debug("Manifest '{}' written to '{}'", (Object)MANIFEST_PATH, (Object)dar);
        }
        finally {
            Closeables.close((Closeable)out, (boolean)false);
        }
    }

    public static void flush(@Nonnull File dar) throws FsSyncException {
        LOGGER.debug("Flushing changes to DAR '{}'", (Object)dar);
        TFile.umount((TFile)new TFile(dar));
    }
}

