/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.dar;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ManifestBuilder {
    private static final String GENERATED_MANIFEST_VERSION = "1.0";
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentMap<String, String> mainAttributes = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, Map<String, String>> entryAttributes = new ConcurrentHashMap<String, Map<String, String>>();

    public ManifestBuilder addMainAttribute(@Nonnull String name, @Nonnull String value) {
        this.mainAttributes.put((String)Preconditions.checkNotNull((Object)name), (String)Preconditions.checkNotNull((Object)value));
        return this;
    }

    public ManifestBuilder addEntryAttributes(@Nonnull String entryName, @Nonnull Map<String, String> attributes) {
        this.entryAttributes.putIfAbsent(entryName, new ConcurrentHashMap(((Map)Preconditions.checkNotNull(attributes)).size()));
        ((Map)this.entryAttributes.get(entryName)).putAll(attributes);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.mainAttributes.isEmpty() && this.entryAttributes.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Manifest build() {
        Manifest manifest = new Manifest();
        Attributes manifestMainAttributes = manifest.getMainAttributes();
        manifestMainAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), GENERATED_MANIFEST_VERSION);
        Map<String, Attributes> manifestEntries = manifest.getEntries();
        this.lock.lock();
        try {
            for (Map.Entry mainAttribute : this.mainAttributes.entrySet()) {
                manifestMainAttributes.putValue((String)mainAttribute.getKey(), (String)mainAttribute.getValue());
            }
            for (Map.Entry attributesForEntry : this.entryAttributes.entrySet()) {
                manifestEntries.put((String)attributesForEntry.getKey(), ManifestBuilder.toAttributes((Map)attributesForEntry.getValue()));
            }
        }
        finally {
            this.lock.unlock();
        }
        return manifest;
    }

    private static Attributes toAttributes(Map<String, String> values) {
        Attributes attributes = new Attributes(values.size());
        for (Map.Entry<String, String> value : values.entrySet()) {
            attributes.putValue(value.getKey(), value.getValue());
        }
        return attributes;
    }
}

