/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class Files2 {
    private static final IOFileFilter TRUE = TrueFileFilter.INSTANCE;
    private static final IOFileFilter FALSE = FalseFileFilter.INSTANCE;

    public static boolean delete(@Nullable File file) {
        if (file != null) {
            return file.delete();
        }
        return false;
    }

    public static void deleteOnExit(@Nullable File file) {
        if (file != null) {
            file.deleteOnExit();
        }
    }

    public static String getTempFilePath(String basename, String ext) throws IOException {
        File tempFile = File.createTempFile(basename, ext);
        String tempFilePath = tempFile.getPath();
        tempFile.delete();
        return tempFilePath;
    }

    @Nonnull
    public static Collection<File> listEntriesRecursively(@Nonnull File directory) {
        return Files2.listFiles(directory, TRUE, TRUE, true);
    }

    @Nonnull
    public static Collection<File> listEntries(@Nonnull File directory) {
        return Files2.listFiles(directory, TRUE, TRUE, false);
    }

    @Nonnull
    public static Collection<File> listFilesRecursively(@Nonnull File directory) {
        return Files2.listFiles(directory, TRUE, FALSE, true);
    }

    @Nonnull
    public static Collection<File> listFiles(@Nonnull File directory) {
        return Files2.listFiles(directory, TRUE, FALSE, false);
    }

    public static Collection<File> listFiles(File directory, IOFileFilter fileFilter, IOFileFilter dirFilter, boolean includeDirs) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(String.format("Parameter '%s' is not a directory", directory));
        }
        if (fileFilter == null) {
            throw new NullPointerException("Parameter 'fileFilter' is null");
        }
        IOFileFilter effFileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)DirectoryFileFilter.INSTANCE));
        IOFileFilter effDirFilter = dirFilter == null ? FalseFileFilter.INSTANCE : FileFilterUtils.andFileFilter((IOFileFilter)dirFilter, (IOFileFilter)DirectoryFileFilter.INSTANCE);
        LinkedList<File> files = new LinkedList<File>();
        Files2.innerListFiles(files, directory, FileFilterUtils.orFileFilter((IOFileFilter)effFileFilter, (IOFileFilter)effDirFilter), includeDirs);
        return files;
    }

    private static void innerListFiles(Collection<File> files, File directory, IOFileFilter filter, boolean includeDirs) {
        File[] found = directory.listFiles((FileFilter)filter);
        if (found != null) {
            for (int i = 0; i < found.length; ++i) {
                boolean isDir = found[i].isDirectory();
                if (!isDir || includeDirs) {
                    files.add(found[i]);
                }
                if (!isDir) continue;
                Files2.innerListFiles(files, found[i], filter, includeDirs);
            }
        }
    }
}

