/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.io;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.cli.ext.plainarchive.io.Files2;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import javax.annotation.Nonnull;

public class TFiles {
    @Nonnull
    public static Iterable<TFile> listTFiles(@Nonnull TFile archive) {
        return Iterables.transform(Files2.listEntriesRecursively((File)archive), (Function)new Function<File, TFile>(){

            public TFile apply(File input) {
                Preconditions.checkArgument((boolean)(input instanceof TFile), (String)"'%s' is not a TFile", (Object[])new Object[]{input});
                return (TFile)input;
            }
        });
    }

    @Nonnull
    public static String getTopLevelEntryName(@Nonnull TFile entry) {
        TFile enclArchive = entry.getEnclArchive();
        String enclEntryName = entry.getEnclEntryName();
        return enclArchive.equals((Object)entry.getTopLevelArchive()) ? enclEntryName : TFiles.getTopLevelEntryName(enclArchive) + "/" + enclEntryName;
    }
}

