/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.matcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.cli.ext.plainarchive.io.Files2;
import com.xebialabs.deployit.cli.ext.plainarchive.matcher.ConfigurationItemMatcher;
import com.xebialabs.deployit.cli.ext.plainarchive.matcher.RegexMatcher;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarMatcher
extends RegexMatcher {
    @VisibleForTesting
    static final String CONTAINS_LIBRARIES_PROPERTY = "containsLibs";
    private static final String LIBRARY_DIR = "WEB-INF/lib";
    private static final String LIBRARY_EXTENSION = "jar";
    private static final Logger LOGGER = LoggerFactory.getLogger(CarMatcher.class);
    private Boolean containsLibraries;

    public CarMatcher(@Nonnull Map<String, String> config) {
        super(config);
    }

    @Override
    protected boolean matches(TFile input) {
        if (!super.matches(input)) {
            return false;
        }
        this.containsLibraries = CarMatcher.containsLibraries(input);
        LOGGER.trace("Checked if CAR '{}' contains libraries (ext '{}') in '{}': {}", new Object[]{input, LIBRARY_EXTENSION, LIBRARY_DIR, this.containsLibraries != false ? "yes" : "no"});
        return true;
    }

    private static boolean containsLibraries(TFile car) {
        String nameSuffixToMatch = ".jar";
        return Iterables.any(Files2.listFiles((File)new TFile((File)car, LIBRARY_DIR)), (Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                return input.getName().endsWith(".jar");
            }
        });
    }

    @Override
    protected Map<String, String> getCiProperties() {
        Preconditions.checkState((this.containsLibraries != null ? 1 : 0) != 0, (Object)"'getCiProperties' called before successful match");
        ImmutableMap.Builder ciProperties = ImmutableMap.builder();
        ciProperties.putAll(super.getCiProperties());
        if (this.containsLibraries.booleanValue()) {
            ciProperties.put((Object)CONTAINS_LIBRARIES_PROPERTY, (Object)this.containsLibraries.toString());
        }
        return ciProperties.build();
    }

    @Override
    public String toString() {
        return "CarMatcher []";
    }

    public static class CarMatcherFactory
    implements ConfigurationItemMatcher.MatcherFactory {
        public static final String MATCHER_TYPE = "car";

        @Override
        public String getMatcherType() {
            return MATCHER_TYPE;
        }

        @Override
        public CarMatcher from(Map<String, String> config) {
            return new CarMatcher(config);
        }
    }
}

