/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.matcher;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.cli.ext.plainarchive.base.UriQueryStrings;
import com.xebialabs.deployit.cli.ext.plainarchive.dar.DarManifestBuilder;
import de.schlichtherle.truezip.file.TFile;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ConfigurationItemMatcher
implements Function<TFile, MatchResult> {
    private static final String RETURNED_TYPE_PROPERTY = "returned.ci";
    private static final String CI_PROPERTIES_PROPERTY = "ci.properties";
    @Nonnull
    protected final String returnedType;
    @Nullable
    protected final String ciProperties;

    protected ConfigurationItemMatcher(@Nonnull Map<String, String> config) {
        this.validate(config);
        this.returnedType = config.get(RETURNED_TYPE_PROPERTY);
        this.ciProperties = config.get(CI_PROPERTIES_PROPERTY);
    }

    protected void validate(@Nonnull Map<String, String> config) {
        Preconditions.checkArgument((boolean)config.containsKey(RETURNED_TYPE_PROPERTY), (String)"config property '%s' is required", (Object[])new Object[]{RETURNED_TYPE_PROPERTY});
    }

    @Nonnull
    public MatchResult apply(@Nonnull TFile input) {
        boolean matched = this.matches(input);
        DarManifestBuilder.DarEntry entry = matched ? new DarManifestBuilder.DarEntry(this.returnedType, this.getCiProperties(), input.getEnclEntryName()) : null;
        return new MatchResult(matched, entry);
    }

    protected abstract boolean matches(@Nonnull TFile var1);

    @Nonnull
    protected Map<String, String> getCiProperties() {
        return this.ciProperties != null ? UriQueryStrings.toMap(this.ciProperties) : ImmutableMap.of();
    }

    public static interface MatcherFactory {
        @Nonnull
        public String getMatcherType();

        @Nonnull
        public ConfigurationItemMatcher from(@Nonnull Map<String, String> var1);
    }

    public static class MatchResult {
        public final boolean matched;
        @Nullable
        public final DarManifestBuilder.DarEntry result;

        protected MatchResult(boolean matched, @Nullable DarManifestBuilder.DarEntry result) {
            this.matched = matched;
            this.result = result;
        }
    }
}

