/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.matcher;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.cli.ext.plainarchive.io.TFiles;
import com.xebialabs.deployit.cli.ext.plainarchive.matcher.ConfigurationItemMatcher;
import de.schlichtherle.truezip.file.TFile;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMatcher
extends ConfigurationItemMatcher {
    private static final String PATH_PROPERTY = "path";
    private static final Logger LOGGER = LoggerFactory.getLogger(PathMatcher.class);
    @Nonnull
    protected final String pathToMatch;

    public PathMatcher(@Nonnull Map<String, String> config) {
        super(config);
        this.pathToMatch = config.get(PATH_PROPERTY);
    }

    @Override
    protected void validate(Map<String, String> config) {
        super.validate(config);
        Preconditions.checkArgument((boolean)config.containsKey(PATH_PROPERTY), (String)"config property '%s' is required", (Object[])new Object[]{PATH_PROPERTY});
    }

    @Override
    protected boolean matches(TFile input) {
        String topLevelEntryName = TFiles.getTopLevelEntryName(input);
        boolean matches = topLevelEntryName.equals(this.pathToMatch);
        LOGGER.trace("Attempted to match path '{}' against literal '{}': {}", new Object[]{topLevelEntryName, this.pathToMatch, matches ? "succeeded" : "failed"});
        return matches;
    }

    public static class PathMatcherFactory
    implements ConfigurationItemMatcher.MatcherFactory {
        public static final String MATCHER_TYPE = "path";

        @Override
        public String getMatcherType() {
            return "path";
        }

        @Override
        public PathMatcher from(Map<String, String> config) {
            return new PathMatcher(config);
        }
    }
}

