/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ext.plainarchive.matcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.cli.ext.plainarchive.base.UriQueryStrings;
import com.xebialabs.deployit.cli.ext.plainarchive.io.TFiles;
import com.xebialabs.deployit.cli.ext.plainarchive.matcher.ConfigurationItemMatcher;
import de.schlichtherle.truezip.file.TFile;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexMatcher
extends ConfigurationItemMatcher {
    private static final String PATTERN_PROPERTY = "pattern";
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexMatcher.class);
    @Nonnull
    protected final Pattern patternToMatch;
    @Nullable
    private MatchResult patternMatchResult;

    public RegexMatcher(@Nonnull Map<String, String> config) {
        super(config);
        this.patternToMatch = Pattern.compile(config.get(PATTERN_PROPERTY));
    }

    @Override
    protected void validate(Map<String, String> config) {
        super.validate(config);
        Preconditions.checkArgument((boolean)config.containsKey(PATTERN_PROPERTY), (String)"config property '%s' is required", (Object[])new Object[]{PATTERN_PROPERTY});
    }

    @Override
    protected boolean matches(TFile input) {
        String topLevelEntryName = TFiles.getTopLevelEntryName(input);
        Matcher patternMatcher = this.patternToMatch.matcher(topLevelEntryName);
        boolean matches = patternMatcher.matches();
        LOGGER.trace("Attempted to match path '{}' against regex '{}': {}", new Object[]{topLevelEntryName, this.patternToMatch, matches ? "succeeded" : "failed"});
        if (matches) {
            this.patternMatchResult = patternMatcher.toMatchResult();
        }
        return matches;
    }

    @Override
    protected Map<String, String> getCiProperties() {
        Preconditions.checkState((this.patternMatchResult != null ? 1 : 0) != 0, (Object)"'getCiProperties' called before successful match");
        if (this.ciProperties == null) {
            return ImmutableMap.of();
        }
        String resolvedCiProperties = this.ciProperties.contains("$1") ? this.ciProperties.replaceAll(Pattern.quote("$1"), this.patternMatchResult.group(1)) : this.ciProperties;
        return UriQueryStrings.toMap(resolvedCiProperties);
    }

    public String toString() {
        return "RegexMatcher [patternToMatch=" + this.patternToMatch + "]";
    }

    public static class RegexMatcherFactory
    implements ConfigurationItemMatcher.MatcherFactory {
        public static final String MATCHER_TYPE = "regex";

        @Override
        public String getMatcherType() {
            return MATCHER_TYPE;
        }

        @Override
        public RegexMatcher from(Map<String, String> config) {
            return new RegexMatcher(config);
        }
    }
}

