/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad;

import com.xebia.ad.DeployItConfiguration;
import com.xebia.ad.ReleaseInfo;
import com.xebia.ad.jetty.ClassPathResourceContentServlet;
import flex.messaging.MessageBrokerServlet;
import java.net.ServerSocket;
import java.util.EventListener;
import java.util.HashMap;
import javax.servlet.Servlet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.servlet.DispatcherServlet;

public class Server {
    private final DeployItConfiguration deployItConfiguration;
    private final ReleaseInfo releaseInfo;
    private org.mortbay.jetty.Server jettyServer;
    private Context contextRoot;
    private static volatile boolean shutdownRequested = false;
    private static Logger logger = Logger.getLogger(Server.class);

    public static void main(String[] args) {
        DeployItConfiguration configuration = DeployItConfiguration.loadForUse();
        Server server = new Server(configuration, ReleaseInfo.getReleaseInfo());
        server.start();
    }

    public Server(DeployItConfiguration configuration, ReleaseInfo releaseInfo) {
        this.deployItConfiguration = configuration;
        this.releaseInfo = releaseInfo;
        if (this.portIsAvailable()) {
            this.setupJetty();
            this.setupSpring();
            this.setupBlazeDS();
            this.setupHessian();
        } else {
            logger.error((Object)("Cannot start Deployit server, port " + this.deployItConfiguration.getHttpPort() + " already in use."));
            logger.error((Object)"Perhaps another instance of Deployit is running. If so, please shutdown the other instance of Deployit.");
            System.exit(1);
        }
    }

    private boolean portIsAvailable() {
        try {
            ServerSocket socket = new ServerSocket(this.deployItConfiguration.getHttpPort());
            socket.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void start() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Starting Jetty");
            }
            this.jettyServer.start();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Jetty started");
            }
            logger.info((Object)"The Deployit server has started.");
            logger.info((Object)("You can now point your browser to " + (this.deployItConfiguration.isSsl() ? "https" : "http") + "://localhost:" + this.deployItConfiguration.getHttpPort() + " or start the command line interface with \"deployit.cmd cli\" or \"./deployit.sh cli\"."));
            shutdownRequested = false;
            Thread shutdownServerThread = new Thread(new Runnable(){

                public void run() {
                    while (!shutdownRequested) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Stopping Jetty.");
                    }
                    try {
                        Server.this.jettyServer.stop();
                        logger.info((Object)"Server stopped.");
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error occurred while trying to stop Jetty", (Throwable)e);
                    }
                }
            });
            shutdownServerThread.start();
        }
        catch (Exception e) {
            logger.error((Object)"Error occured while starting Jetty", (Throwable)e);
        }
    }

    private void setupJetty() {
        int port = this.deployItConfiguration.getHttpPort();
        String webContextRoot = "/";
        String documentRootPackage = "web";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting up Jetty server on port " + port + " with context root " + webContextRoot + " using package " + documentRootPackage + " for document root."));
        }
        if (this.deployItConfiguration.isSsl()) {
            this.checkProductionRelease("SSL");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Setting up Jetty to use SSL");
            }
            this.jettyServer = new org.mortbay.jetty.Server();
            SslSocketConnector connector = new SslSocketConnector();
            connector.setPort(port);
            connector.setMaxIdleTime(30000);
            connector.setKeystore(this.deployItConfiguration.getKeyStorePath());
            connector.setPassword(this.deployItConfiguration.getKeyStorePassword());
            connector.setKeyPassword(this.deployItConfiguration.getKeyStoreKeyPassword());
            String protocol = this.deployItConfiguration.getSslProtocol();
            if (!StringUtils.isBlank((String)protocol)) {
                connector.setProtocol(protocol);
            }
            this.jettyServer.addConnector((Connector)connector);
        } else {
            this.jettyServer = new org.mortbay.jetty.Server(port);
        }
        BoundedThreadPool btp = new BoundedThreadPool();
        btp.setMinThreads(this.deployItConfiguration.getMinThreads());
        btp.setMaxThreads(this.deployItConfiguration.getMaxThreads());
        this.jettyServer.setThreadPool((ThreadPool)btp);
        this.contextRoot = new Context((HandlerContainer)this.jettyServer, webContextRoot, 1);
        ServletHolder documentHolder = new ServletHolder();
        documentHolder.setServlet((Servlet)new ClassPathResourceContentServlet(documentRootPackage));
        this.contextRoot.addServlet(documentHolder, "/");
        this.contextRoot.setResourceBase(".");
    }

    private void checkProductionRelease(String feature) {
        if (!this.releaseInfo.isProductionRelease()) {
            logger.error((Object)(feature + " is not available in Personal Edition!"));
            System.exit(1);
        }
    }

    private void setupSpring() {
        String springContexts;
        if (this.deployItConfiguration.isSecured()) {
            this.checkProductionRelease("Security");
            springContexts = StringUtils.equalsIgnoreCase((String)this.deployItConfiguration.getLdapHost(), (String)"builtin") ? "classpath:spring/ad-core-context-common.xml \n classpath:spring/ad-core-context.xml \n classpath:spring/ad-core-context-security-builtin.xml" : "classpath:spring/ad-core-context-common.xml \n classpath:spring/ad-core-context.xml \n classpath:spring/ad-core-context-security-ldap.xml";
        } else {
            springContexts = "classpath:spring/ad-core-context-common.xml \n classpath:spring/ad-core-context.xml";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("contextConfigLocation", springContexts);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using Spring configuration - " + (String)params.get("contextConfigLocation")));
        }
        this.contextRoot.setInitParams(params);
        this.contextRoot.addEventListener((EventListener)new ContextLoaderListener());
        if (this.deployItConfiguration.isSecured()) {
            this.checkProductionRelease("Security");
            FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
            filter.setName("springSecurityFilterChain");
            this.contextRoot.addFilter(filter, "/remoting/*", 1);
        }
    }

    private void setupBlazeDS() {
        ServletHolder holder = new ServletHolder((Servlet)new MessageBrokerServlet());
        holder.setName("BlazeDSServlet");
        holder.setInitParameter("services.configuration.file", this.deployItConfiguration.isSecured() ? "blazeds/secured/blazeds-services-config.xml" : "blazeds/unsecured/blazeds-services-config.xml");
        holder.setInitParameter("services.configuration.parser", "com.xebia.ad.blazeds.BlazeDSResourceConfigurationParser");
        holder.setInitParameter("flex.write.path", "blazeds/");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using BlazeDS configuration - " + holder.getInitParameter("services.configuration.file")));
        }
        this.contextRoot.addServlet(holder, "/messagebroker/*");
    }

    private void setupHessian() {
        ServletHolder holder = new ServletHolder((Servlet)new DispatcherServlet());
        holder.setName("HessianServlet");
        holder.setInitParameter("contextConfigLocation", "classpath:hessian/remoting-servlet.xml");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using Hessian configuration - " + holder.getInitParameter("contextConfigLocation")));
        }
        this.contextRoot.addServlet(holder, "/remoting/*");
    }

    public static void shutdown() {
        logger.info((Object)"Received message to shutdown the server.");
        shutdownRequested = true;
    }
}

