/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.application.importer;

import com.xebia.ad.application.importer.DeploymentPackageImportErrors;
import com.xebia.ad.application.importer.DeploymentPackageImportService;
import com.xebia.ad.application.importer.DeploymentPackageLocation;
import com.xebia.ad.repository.ConfigurationItemTypeDescriptorRepository;
import com.xebia.ad.repository.metadata.Change;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.service.RepositoryService;
import com.xebia.ad.support.Triple;
import com.xebialabs.deployit.ci.Application;
import com.xebialabs.deployit.ci.DeploymentPackage;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.DeployableArtifact;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.security.AccessControlEntry;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestBasedDeploymentPackageImportService
implements DeploymentPackageImportService {
    public static final String PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME = "Deployit-Package-Format-Version";
    public static final String PACKAGE_FORMAT_VERSION_NUMBER = "1.0";
    public static final String APPLICATION_ATTRIBUTE_NAME = "Deployit-Application";
    public static final String VERSION_ATTRIBUTE_NAME = "Deployit-Version";
    public static final String TYPE_ATTRIBUTE_NAME = "Deployit-Type";
    public static final String NAME_ATTRIBUTE_NAME = "Deployit-Name";
    public static final String NAMESPACE_SEPARATOR = "/";
    private RepositoryService repositoryService;
    private ConfigurationItemTypeDescriptorRepository typeRepository;
    private final File dataDirectory;

    public ManifestBasedDeploymentPackageImportService(RepositoryService repositoryService, ConfigurationItemTypeDescriptorRepository typeRepository, File dataDir) {
        this.repositoryService = repositoryService;
        this.typeRepository = typeRepository;
        this.dataDirectory = dataDir;
    }

    @Override
    public void validateAndImport(HostFile deploymentPackageDir) throws DeploymentPackageImportErrors, RuntimeIOException {
        ConfigurationItemHandle applicationHandle;
        if (!deploymentPackageDir.exists()) {
            throw new DeploymentPackageImportErrors("Deployment package " + deploymentPackageDir + " does not exist");
        }
        if (!deploymentPackageDir.isDirectory()) {
            throw new DeploymentPackageImportErrors("Deployment package " + deploymentPackageDir + " is not a directory");
        }
        HostFile manifestFile = deploymentPackageDir.getFile("META-INF/MANIFEST.MF");
        if (!manifestFile.exists()) {
            throw new DeploymentPackageImportErrors("Deployment package " + deploymentPackageDir + " has no META-INF/MANIFEST.MF file");
        }
        Manifest manifest = ManifestBasedDeploymentPackageImportService.readManifest(manifestFile);
        Attributes mainAttributes = manifest.getMainAttributes();
        String packageFormatVersion = mainAttributes.getValue(PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME);
        if (packageFormatVersion == null) {
            packageFormatVersion = "unspecified";
        }
        if (!PACKAGE_FORMAT_VERSION_NUMBER.equals(packageFormatVersion)) {
            throw new DeploymentPackageImportErrors("Deployment package " + deploymentPackageDir + " does not have the right " + PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME + " header value (actual: " + packageFormatVersion + " expected: " + PACKAGE_FORMAT_VERSION_NUMBER + ")");
        }
        String applicationName = mainAttributes.getValue(APPLICATION_ATTRIBUTE_NAME);
        if (StringUtils.isBlank((String)applicationName)) {
            throw new DeploymentPackageImportErrors("Deployment package " + deploymentPackageDir + " does not declare its application name using the " + APPLICATION_ATTRIBUTE_NAME + " main attribute");
        }
        String packageVersion = mainAttributes.getValue(VERSION_ATTRIBUTE_NAME);
        if (StringUtils.isBlank((String)packageVersion)) {
            throw new DeploymentPackageImportErrors("Deployment package " + deploymentPackageDir + " does not declare its version number using the " + VERSION_ATTRIBUTE_NAME + " main attribute");
        }
        DeploymentPackage pkg = new DeploymentPackage();
        pkg.setVersion(packageVersion);
        ConfigurationItemRevision pkgRevision = new ConfigurationItemRevision(pkg);
        HostSession lhs = HostSessionFactory.getHostSession((Host)Host.getLocalHost());
        HostFile dataDir = lhs.getFile(this.dataDirectory.getPath());
        int nrOfEntriesFound = 0;
        ConfigurationItemDescriptor deploymentPackageDescriptor = this.typeRepository.getDescriptor(DeploymentPackage.class);
        HashSet<ConfigurationItemHandle> artifactHandles = new HashSet<ConfigurationItemHandle>();
        for (Map.Entry<String, Attributes> each : manifest.getEntries().entrySet()) {
            String entryName = each.getKey();
            Attributes entryAttributes = each.getValue();
            String entryType = entryAttributes.getValue(TYPE_ATTRIBUTE_NAME);
            if (entryType == null) continue;
            ConfigurationItemDescriptor descriptor = null;
            for (ConfigurationItemDescriptor eachTD : this.typeRepository.getDescriptors()) {
                if (!eachTD.getSimpleName().equalsIgnoreCase(entryType)) continue;
                descriptor = eachTD;
            }
            if (descriptor == null) {
                throw new DeploymentPackageImportErrors("Entry " + entryName + " in deployment package " + deploymentPackageDir + " is of an unknown type: " + entryType);
            }
            if (!descriptor.getSuperClasses().contains(DeployableArtifact.class.getName())) {
                throw new DeploymentPackageImportErrors("Entry " + entryName + " in deployment package " + deploymentPackageDir + " is of a type that is not a subclass of DeployableArtifact: " + entryType);
            }
            DeployableArtifact artifact = (DeployableArtifact)descriptor.newInstance();
            String artifactLabel = applicationName + NAMESPACE_SEPARATOR + packageVersion + NAMESPACE_SEPARATOR + entryName;
            ConfigurationItemRevision artifactRevision = new ConfigurationItemRevision(artifact);
            ConfigurationItemHandle artifactHandle = this.repositoryService.addConfigurationItem(artifactLabel, "", descriptor.getType(), artifactRevision);
            String artifactFilename = artifactHandle.getId() + ".dat";
            HostFile importedArtifact = dataDir.getFile(artifactFilename);
            HostFile packageArtifact = deploymentPackageDir.getFile(entryName);
            try {
                HostFileUtils.copy((HostFile)packageArtifact, (HostFile)importedArtifact);
            }
            catch (RuntimeIOException exc) {
                throw new DeploymentPackageImportErrors("Cannot read artifact " + entryName + " from deployment package " + deploymentPackageDir + ": " + (Object)((Object)exc));
            }
            artifact.setLocation(importedArtifact.getPath());
            if (descriptor.getSuperClasses().contains(NamedDeployableArtifact.class.getName())) {
                String artifactName = entryAttributes.getValue(NAME_ATTRIBUTE_NAME);
                ((NamedDeployableArtifact)artifact).setName(StringUtils.isNotBlank((String)artifactName) ? artifactName : ManifestBasedDeploymentPackageImportService.generateDefaultName(packageArtifact));
            }
            artifactRevision.setDetailsObject(artifact);
            ++nrOfEntriesFound;
            artifactHandles.add(artifactHandle);
        }
        if (nrOfEntriesFound == 0) {
            throw new DeploymentPackageImportErrors("Application package " + deploymentPackageDir + " does not contain any artifacts");
        }
        Triple<ConfigurationItemRevision, Change, AccessControlEntry> existingAplicationRevisionInfo = this.repositoryService.findDesignRevisionByLabel(applicationName);
        if (existingAplicationRevisionInfo != null) {
            applicationHandle = existingAplicationRevisionInfo.getFirst().getHandle();
        } else {
            Application newApplication = new Application();
            ConfigurationItemRevision newApplicationRevision = new ConfigurationItemRevision(newApplication);
            applicationHandle = this.repositoryService.addConfigurationItem(applicationName, "", newApplication.getClass().getName(), newApplicationRevision);
        }
        String deployableArtifactsPropertyName = this.getDeployableArtifactPropertyName(deploymentPackageDescriptor);
        pkgRevision.addRelatedCiHandles(deployableArtifactsPropertyName, artifactHandles);
        String applicationPropertyName = this.getApplicationPropertyName(deploymentPackageDescriptor);
        pkgRevision.addRelatedCiHandle(applicationPropertyName, applicationHandle);
        this.repositoryService.addConfigurationItem(applicationName + NAMESPACE_SEPARATOR + packageVersion, "", pkg.getClass().getName(), pkgRevision);
    }

    private static Manifest readManifest(HostFile manifestFile) {
        Manifest manifest;
        InputStream in = manifestFile.get();
        try {
            manifest = new Manifest(in);
        }
        catch (IOException exception) {
            throw new RuntimeIOException("Cannot read manifest file " + manifestFile, (Throwable)exception);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return manifest;
    }

    private String getDeployableArtifactPropertyName(ConfigurationItemDescriptor deploymentPackageDescriptor) {
        String deployableArtifactsPropertyName = null;
        for (ConfigurationItemPropertyDescriptor configurationItemPropertyDescriptor : deploymentPackageDescriptor.getPropertyDescriptors()) {
            if (configurationItemPropertyDescriptor.getCollectionMemberClass() == null || !configurationItemPropertyDescriptor.getCollectionMemberClass().equals(DeployableArtifact.class)) continue;
            deployableArtifactsPropertyName = configurationItemPropertyDescriptor.getName();
        }
        return deployableArtifactsPropertyName;
    }

    private String getApplicationPropertyName(ConfigurationItemDescriptor deploymentPackageDescriptor) {
        return "application";
    }

    private static String generateDefaultName(HostFile packageArtifact) {
        return FilenameUtils.getBaseName((String)packageArtifact.getName());
    }

    @Override
    public Collection<DeploymentPackageLocation> getDeploymentPackageList(String location) {
        File[] listFiles;
        ArrayList<DeploymentPackageLocation> deploymentPackageLocation = new ArrayList<DeploymentPackageLocation>();
        if (location == null) {
            return deploymentPackageLocation;
        }
        File componentDir = new File(location);
        if (!componentDir.exists()) {
            return deploymentPackageLocation;
        }
        for (File applicationDir : listFiles = componentDir.listFiles()) {
            if (!applicationDir.isDirectory() || applicationDir.listFiles() == null || applicationDir.getName().startsWith(".")) continue;
            for (File deploymentPackageDir : applicationDir.listFiles()) {
                if (!deploymentPackageDir.isDirectory() || !this.isValidDirectoryName(deploymentPackageDir)) continue;
                deploymentPackageLocation.add(new DeploymentPackageLocation(deploymentPackageDir));
            }
        }
        return deploymentPackageLocation;
    }

    private boolean isValidDirectoryName(File dir) {
        if (dir == null) {
            return false;
        }
        String name = dir.getName();
        return this.startsWithNumber(name);
    }

    private boolean startsWithNumber(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        String firstPart = name.substring(0, 1);
        return "0123456789".indexOf(firstPart) != -1;
    }
}

