/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.dao.impl;

import com.xebia.ad.dao.BaseDao;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional
public class JpaBaseDaoImpl<T>
implements BaseDao<T> {
    private Class<T> persistentClass;
    private String entityName;
    @PersistenceContext
    protected EntityManager entityManager;

    public JpaBaseDaoImpl(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    @Override
    public List<T> findAll() {
        Query query = this.entityManager.createQuery("select entity from " + this.getEntityName() + " entity");
        return query.getResultList();
    }

    @Override
    public T findById(Serializable id) {
        return (T)this.entityManager.find(this.persistentClass, (Object)id);
    }

    @Override
    public T getById(Serializable id) {
        Object entity = this.entityManager.find(this.persistentClass, (Object)id);
        if (entity == null) {
            throw new EntityNotFoundException(this.getEntityName() + " with id = " + id + " not found");
        }
        return (T)entity;
    }

    @Override
    public void persist(T entity) {
        this.entityManager.persist(entity);
    }

    @Override
    public void remove(T entity) {
        this.entityManager.remove(entity);
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected String getEntityName() {
        if (this.entityName == null) {
            Entity entityAnn = this.persistentClass.getAnnotation(Entity.class);
            this.entityName = entityAnn != null && !entityAnn.name().equals("") ? entityAnn.name() : this.persistentClass.getSimpleName();
        }
        return this.entityName;
    }
}

