/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.repository.metadata;

import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ChangeType;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.support.Idable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import org.apache.log4j.Logger;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@javax.persistence.Table(name="CHANGES")
@Table(appliesTo="CHANGES", indexes={@Index(name="CHANGES_HANDLE", columnNames={"HANDLE_ID"}), @Index(name="CHANGES_CHANGEPLAN", columnNames={"CHANGEPLAN_ID"})})
@NamedQueries(value={@NamedQuery(name="getChange", query="SELECT change FROM Change change WHERE change.changePlan = :changePlan AND change.handle.id = :handleId")})
public class Change
implements Idable {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="CHANGEPLAN_ID")
    @ForeignKey(name="FK_CHANGES_CHANGEPLAN")
    private ChangePlan changePlan;
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="HANDLE_ID")
    @ForeignKey(name="FK_CHANGES_HANDLE")
    private ConfigurationItemHandle handle;
    @OneToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="OLD_REVISION_ID")
    @ForeignKey(name="FK_CHANGES_OLD_REVISION")
    private ConfigurationItemRevision oldRevision;
    @OneToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="NEW_REVISION_ID")
    @ForeignKey(name="FK_CHANGES_NEW_REVISION")
    private ConfigurationItemRevision newRevision;
    private static Logger logger = Logger.getLogger(Change.class);

    public static Change newAddition(ConfigurationItemRevision addedRevision) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating ADDITION change for " + addedRevision));
        }
        Change c = new Change();
        c.setHandle(addedRevision.getHandle());
        c.setOldRevision(null);
        c.setNewRevision(addedRevision);
        return c;
    }

    public static Change newModification(ConfigurationItemRevision modifiedRevision) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating MODIFICATION change for " + modifiedRevision));
        }
        Change c = new Change();
        c.setHandle(modifiedRevision.getHandle());
        c.setOldRevision(modifiedRevision.getHandle().getActualRevision());
        c.setNewRevision(modifiedRevision);
        return c;
    }

    public boolean isDependencyModification() {
        return this.getOldRevision() == this.getNewRevision() && this.getNewRevision() != null;
    }

    public static Change newDeletion(ConfigurationItemRevision deletedRevision) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating DELETION change for " + deletedRevision));
        }
        Change c = new Change();
        c.setHandle(deletedRevision.getHandle());
        c.setOldRevision(deletedRevision.getHandle().getActualRevision());
        c.setNewRevision(null);
        return c;
    }

    public String getConfigurationItemType() {
        return this.getApplicableRevision().getType();
    }

    public ConfigurationItemRevision getApplicableRevision() {
        switch (this.getType()) {
            case ADDITION: 
            case MODIFICATION: {
                return this.getNewRevision();
            }
            case DELETION: {
                return this.getOldRevision();
            }
        }
        throw new IllegalStateException("Change " + this.getId() + " has unknown type " + (Object)((Object)this.getType()));
    }

    public ChangeType getType() {
        if (this.getOldRevision() == null) {
            assert (this.getNewRevision() != null);
            return ChangeType.ADDITION;
        }
        if (this.getNewRevision() == null) {
            assert (this.getOldRevision() != null);
            return ChangeType.DELETION;
        }
        return ChangeType.MODIFICATION;
    }

    public String toString() {
        ConfigurationItemRevision revision = this.getApplicableRevision();
        return "Change(id=" + this.getId() + ") on a " + revision.getType();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ChangePlan getChangePlan() {
        return this.changePlan;
    }

    public void internalSetChangePlan(ChangePlan changePlan) {
        this.changePlan = changePlan;
    }

    public ConfigurationItemHandle getHandle() {
        return this.handle;
    }

    public void setHandle(ConfigurationItemHandle handle) {
        this.handle = handle;
    }

    public ConfigurationItemRevision getOldRevision() {
        return this.oldRevision;
    }

    public void setOldRevision(ConfigurationItemRevision oldRevision) {
        this.oldRevision = oldRevision;
    }

    public ConfigurationItemRevision getNewRevision() {
        return this.newRevision;
    }

    public void setNewRevision(ConfigurationItemRevision newRevision) {
        this.newRevision = newRevision;
    }
}

