/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.service.dto;

import com.google.common.base.Preconditions;
import com.xebia.ad.dao.ConfigurationItemHandleDao;
import com.xebia.ad.repository.ConfigurationItemTypeDescriptorRepository;
import com.xebia.ad.repository.metadata.Change;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.repository.metadata.Step;
import com.xebia.ad.service.ConfigurationItemMetaData;
import com.xebia.ad.service.ConfigurationItemState;
import com.xebia.ad.service.RepositoryService;
import com.xebia.ad.service.design.ui.ChangePlanView;
import com.xebia.ad.service.design.ui.ChangeView;
import com.xebia.ad.service.design.ui.StepView;
import com.xebia.ad.service.dto.ConfigurationItemDetailsMapDeserializer;
import com.xebia.ad.service.dto.DTOFactory;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ci.security.AccessControlEntry;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional(propagation=Propagation.MANDATORY)
public class DTOFactoryImpl
implements DTOFactory {
    private final RepositoryService repositoryService;
    private final ConfigurationItemTypeDescriptorRepository descriptorRepository;
    private final ConfigurationItemHandleDao configurationItemHandleDao;
    private final Logger log = Logger.getLogger(DTOFactoryImpl.class);

    @Autowired
    public DTOFactoryImpl(@Qualifier(value="defaultRepositoryService") RepositoryService repositoryService, ConfigurationItemTypeDescriptorRepository descriptorRepository, ConfigurationItemHandleDao configurationItemHandleDao) {
        this.repositoryService = repositoryService;
        this.descriptorRepository = descriptorRepository;
        this.configurationItemHandleDao = configurationItemHandleDao;
    }

    @Override
    public ChangePlanView createChangePlanView(ChangePlan changePlan) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Creating change plan view");
        }
        ChangePlanView cpv = new ChangePlanView();
        cpv.setId(changePlan.getId());
        cpv.setState(changePlan.getState().toString());
        cpv.setResolutionError(changePlan.getResolutionError());
        cpv.setStartOfExecution(changePlan.getStartOfExecution());
        cpv.setEndOfExecution(changePlan.getEndOfExecution());
        ArrayList<ChangeView> changes = new ArrayList<ChangeView>();
        for (Change c : changePlan.getChanges()) {
            ChangeView cv = this.createChangeView(c);
            changes.add(cv);
        }
        cpv.setChanges(changes);
        ArrayList<StepView> steps = new ArrayList<StepView>();
        for (Step s : changePlan.getSteps()) {
            steps.add(this.createStepView(s));
        }
        cpv.setSteps(steps);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Created change plan view for change plan with ID " + cpv.getId()));
        }
        return cpv;
    }

    @Override
    public ChangeView createChangeView(Change change) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Creating change view");
        }
        ChangeView cv = new ChangeView();
        cv.setId(change.getId());
        cv.setDescription((Object)((Object)change.getType()) + " of " + change.getHandle().getLabel());
        cv.setChangeType(change.getType().toString());
        cv.setHandleId(change.getHandle().getId());
        cv.setHandleLabel(change.getHandle().getLabel());
        cv.setKey(change.getConfigurationItemType());
        if (change.getOldRevision() != null) {
            cv.setOldMetaData(this.createActualConfigurationItemMetaData(change.getOldRevision(), change));
        }
        if (change.getNewRevision() != null) {
            cv.setNewMetaData(this.createDesignConfigurationItemMetaData(change.getNewRevision(), change));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Created change view for change with ID " + cv.getId()));
        }
        return cv;
    }

    @Override
    public StepView createStepView(Step step) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Creating step view");
        }
        StepView sv = new StepView();
        sv.setId(step.getId());
        sv.setDescription(step.getDescription());
        sv.setState(step.getState().toString());
        sv.setLog(step.getLog());
        sv.setPosition(step.getPosition());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Created step view for step with ID " + sv.getId()));
        }
        return sv;
    }

    @Override
    public ConfigurationItemMetaData createActualConfigurationItemMetaData(ConfigurationItemRevision revision, Change change) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Creating actual ConfigurationItemMetaData");
        }
        AccessControlEntry permissions = this.repositoryService.getPermissionsForCurrentUser(revision);
        ConfigurationItemMetaData ciMetaData = this.createActualConfigurationItemMetaData(revision, change, permissions);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Created actual ConfigurationItemMetaData for configuration item \"" + ciMetaData.getLabel() + "\""));
        }
        return ciMetaData;
    }

    @Override
    public ConfigurationItemMetaData createActualConfigurationItemMetaData(ConfigurationItemRevision revision, Change change, AccessControlEntry permissions) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Creating actual ConfigurationItemMetaData with permissions");
        }
        ConfigurationItemHandle handle = revision.getHandle();
        ConfigurationItemState state = change != null ? change.getType().toConfigurationItemState() : ConfigurationItemState.ACTUAL;
        ConfigurationItemMetaData ciMetaData = new ConfigurationItemMetaData(handle, revision, state, permissions);
        this.getAndPopulateRelationCIs(revision, ciMetaData);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Created actual ConfigurationItemMetaData for configuration item \"" + ciMetaData.getLabel() + "\" with permissions " + permissions));
        }
        return ciMetaData;
    }

    @Override
    public Map<String, Object> createConfigurationItemMap(Serializable item) {
        ConfigurationItemDescriptor descriptor = this.descriptorRepository.getDescriptor(item.getClass().getName());
        if (descriptor == null) {
            throw new IllegalArgumentException("Cannot map configuration item of type " + item.getClass().getName() + " because it is not in the configuration item descriptor repository");
        }
        ConfigurationItemPropertyDescriptor[] propertyDescriptors = descriptor.getPropertyDescriptors();
        return this.createObjectMap(item, propertyDescriptors);
    }

    private Map<String, Object> createObjectMap(Serializable item, ConfigurationItemPropertyDescriptor[] propertyDescriptors) {
        HashMap<String, Object> mappedItem = new HashMap<String, Object>();
        block4: for (ConfigurationItemPropertyDescriptor pd : propertyDescriptors) {
            Object propValue = pd.getPropertyValueFromConfigurationItem((Object)item);
            switch (pd.getType()) {
                case BOOLEAN: 
                case STRING: 
                case INTEGER: 
                case ENUM: 
                case SET_OF_STRINGS: {
                    mappedItem.put(pd.getName(), propValue);
                    continue block4;
                }
                case LIST_OF_OBJECTS: {
                    mappedItem.put(pd.getName(), this.createObjectMapList(pd, (List)propValue));
                }
            }
        }
        return mappedItem;
    }

    private List<Map<String, Object>> createObjectMapList(ConfigurationItemPropertyDescriptor pd, List<Serializable> propValue) {
        ArrayList<Map<String, Object>> mappedList = new ArrayList<Map<String, Object>>();
        if (propValue != null) {
            for (Serializable listObject : propValue) {
                mappedList.add(this.createObjectMap(listObject, pd.getListObjectPropertyDescriptors()));
            }
        }
        return mappedList;
    }

    private Map<String, List<Integer>> getRelationsHandleIds(ConfigurationItemRevision revision, ConfigurationItemMetaData metadata) {
        ConfigurationItemPropertyDescriptor[] propertyDescriptors;
        HashMap<String, List<Integer>> ciRelationsHandleIds = new HashMap<String, List<Integer>>();
        ConfigurationItemDescriptor descriptor = (ConfigurationItemDescriptor)Preconditions.checkNotNull((Object)this.descriptorRepository.getDescriptor(metadata.getConfigurationItemClassName()), (Object)("No descriptor found for CI type " + metadata.getConfigurationItemClassName()));
        block4: for (ConfigurationItemPropertyDescriptor propertyDescriptor : propertyDescriptors = descriptor.getPropertyDescriptors()) {
            switch (propertyDescriptor.getType()) {
                case CI: {
                    ciRelationsHandleIds.put(propertyDescriptor.getName(), DTOFactoryImpl.toHandleIds(revision.getRelatedCiHandle(propertyDescriptor.getName())));
                    continue block4;
                }
                case SET_OF_CIS: {
                    ciRelationsHandleIds.put(propertyDescriptor.getName(), DTOFactoryImpl.toHandleIds(revision.getRelatedCiHandles(propertyDescriptor.getName())));
                }
            }
        }
        return ciRelationsHandleIds;
    }

    private static List<Integer> toHandleIds(ConfigurationItemHandle handle) {
        return DTOFactoryImpl.toHandleIds(handle != null ? Collections.singleton(handle) : new HashSet<ConfigurationItemHandle>());
    }

    private static List<Integer> toHandleIds(Set<ConfigurationItemHandle> handles) {
        ArrayList<Integer> handleIds = new ArrayList<Integer>();
        assert (handles != null);
        for (ConfigurationItemHandle handle : handles) {
            handleIds.add(handle.getId());
        }
        return handleIds;
    }

    @Override
    public ConfigurationItemMetaData createDesignConfigurationItemMetaData(ConfigurationItemRevision revision, Change change) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Creating design ConfigurationItemMetaData");
        }
        AccessControlEntry permissions = this.repositoryService.getPermissionsForCurrentUser(revision);
        ConfigurationItemMetaData ciMetaData = this.createDesignConfigurationItemMetaData(revision, change, permissions);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Created design ConfigurationItemMetaData for configuration item \"" + ciMetaData.getLabel() + "\""));
        }
        return ciMetaData;
    }

    @Override
    public ConfigurationItemMetaData createDesignConfigurationItemMetaData(ConfigurationItemRevision revision, Change change, AccessControlEntry permissions) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Creating design ConfigurationItemMetaData with permissions");
        }
        ConfigurationItemHandle handle = change.getHandle();
        ConfigurationItemState state = change.getType().toConfigurationItemState();
        ConfigurationItemMetaData ciMetaData = new ConfigurationItemMetaData(handle, revision, state, permissions);
        this.getAndPopulateRelationCIs(revision, ciMetaData);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Created design ConfigurationItemMetaData for configuration item \"" + ciMetaData.getLabel() + "\" with permissions " + permissions));
        }
        return ciMetaData;
    }

    private void getAndPopulateRelationCIs(ConfigurationItemRevision revision, ConfigurationItemMetaData ciMetaData) {
        if (revision != null) {
            Map<String, List<Integer>> ciRelationsHandleIds = this.getRelationsHandleIds(revision, ciMetaData);
            ciMetaData.setCiRelationsHandleIds(ciRelationsHandleIds);
        }
    }

    @Override
    public ConfigurationItemRevision createConfigurationItemRevision(ConfigurationItemMetaData metadata, Object serializedCiDetails) {
        ConfigurationItemRevision revision = metadata.getRevision(this.deserializeDetails(metadata, serializedCiDetails));
        this.setRevisionProperties(revision, metadata);
        return revision;
    }

    private Object deserializeDetails(ConfigurationItemMetaData metadata, Object serializedCiDetails) {
        if (serializedCiDetails == null) {
            return null;
        }
        if (serializedCiDetails instanceof Map) {
            return ConfigurationItemDetailsMapDeserializer.toConfigurationItemDetails(this.descriptorRepository.getDescriptor(metadata.getConfigurationItemClassName()), (Map)serializedCiDetails);
        }
        if (serializedCiDetails.getClass().getAnnotation(ConfigurationItem.class) != null) {
            return serializedCiDetails;
        }
        throw new IllegalArgumentException("ciDetails is not a ConfigurationItemDetails or a Map but a " + serializedCiDetails.getClass());
    }

    private void setRevisionProperties(ConfigurationItemRevision revision, ConfigurationItemMetaData metadata) {
        Map<String, List<Integer>> ciRelationsHandleIds = metadata.getCiRelationsHandleIds();
        if (ciRelationsHandleIds != null) {
            ConfigurationItemDescriptor descriptor = (ConfigurationItemDescriptor)Preconditions.checkNotNull((Object)this.descriptorRepository.getDescriptor(metadata.getConfigurationItemClassName()), (Object)("No descriptor found for CI type " + metadata.getConfigurationItemClassName()));
            block4: for (Map.Entry<String, List<Integer>> ciRelationHandleIds : ciRelationsHandleIds.entrySet()) {
                Set<ConfigurationItemHandle> handles = this.toHandles(ciRelationHandleIds.getValue());
                ConfigurationItemPropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(ciRelationHandleIds.getKey());
                switch (propertyDescriptor.getType()) {
                    case CI: {
                        this.setCiProperty(revision, propertyDescriptor, handles);
                        continue block4;
                    }
                    case SET_OF_CIS: {
                        this.setCiSetProperty(revision, propertyDescriptor, handles);
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Property " + propertyDescriptor.getName() + " is not a CI or set of CIs, but a " + propertyDescriptor.getType());
            }
        }
        if (metadata.getPermissionSchemeHandleId() != 0) {
            ConfigurationItemHandle permissionSchemeHandle = (ConfigurationItemHandle)this.configurationItemHandleDao.getById(Integer.valueOf(metadata.getPermissionSchemeHandleId()));
            revision.setPermissionSchemeHandle(permissionSchemeHandle);
        }
    }

    @Override
    public Set<ConfigurationItemHandle> toHandles(List<Integer> handleIds) {
        HashSet<ConfigurationItemHandle> handles = new HashSet<ConfigurationItemHandle>(handleIds.size());
        for (Integer handleId : handleIds) {
            handles.add((ConfigurationItemHandle)this.configurationItemHandleDao.getById(handleId));
        }
        return handles;
    }

    private void setCiProperty(ConfigurationItemRevision revision, ConfigurationItemPropertyDescriptor propertyDescriptor, Set<ConfigurationItemHandle> handles) {
        if (handles.size() > 1) {
            throw new IllegalArgumentException("Property " + propertyDescriptor.getName() + " cannot be related to more than one CI, but is related to " + handles);
        }
        if (!handles.isEmpty()) {
            revision.addRelatedCiHandle(propertyDescriptor.getName(), handles.iterator().next());
        }
    }

    private void setCiSetProperty(ConfigurationItemRevision revision, ConfigurationItemPropertyDescriptor propertyDescriptor, Set<ConfigurationItemHandle> handles) {
        if (!handles.isEmpty()) {
            revision.addRelatedCiHandles(propertyDescriptor.getName(), handles);
        }
    }
}

