/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.cli;

import com.xebia.ad.DeployItConfiguration;
import com.xebia.ad.cli.Interpreter;
import java.io.File;
import java.io.InputStream;
import javax.persistence.Persistence;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class RepoFiller {
    private DeployItConfiguration configuration = DeployItConfiguration.loadForUse();

    public static void main(String[] args) {
        DeployItConfiguration.loadForUse();
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(new String[]{"classpath:/spring/ad-cli-context.xml"});
        RepoFiller filler = new RepoFiller();
        try {
            System.out.println("Trying to create the database.");
            filler.initializeDB();
            System.out.println("Success, database created.");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.exit(1);
        }
        Interpreter interpreter = (Interpreter)ctx.getBean("interpreter");
        if (args.length == 0) {
            filler.fill(interpreter);
        } else {
            File input = new File(args[0]);
            interpreter.interpret(input);
        }
    }

    private void initializeDB() {
        Persistence.createEntityManagerFactory((String)"ad-repository", this.configuration.getCreationalJPAProperties()).createEntityManager();
    }

    private void fill(Interpreter interpreter) {
        InputStream is = this.getClass().getResourceAsStream("vanilla_on_vmware1.adv2");
        interpreter.interpret(is);
    }
}

